/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.client.common;

import com.google.protobuf.BytesValue;
import com.oracle.coherence.grpc.client.common.AsyncNamedCacheClient;
import com.oracle.coherence.grpc.client.common.RemoteCollection;
import com.tangosol.net.RequestIncompleteException;
import com.tangosol.util.ConverterCollections;
import com.tangosol.util.Filter;
import com.tangosol.util.Filters;
import com.tangosol.util.PagedIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;

public class RemoteKeySet<K, V>
extends RemoteCollection<K, V, K>
implements Set<K> {
    public RemoteKeySet(AsyncNamedCacheClient<K, V> client) {
        super(client);
    }

    @Override
    public boolean contains(Object key) {
        if (key == null) {
            throw new NullPointerException("key cannot be null");
        }
        try {
            return this.getCache().containsKeyInternal(key).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    @Override
    public Iterator<K> iterator() {
        return new PagedIterator((PagedIterator.Advancer)new KeysAdvancer(this.getCache()));
    }

    @Override
    public boolean remove(Object key) {
        try {
            return this.getCache().removeInternal(key).get() != null;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    @Override
    public Object[] toArray() {
        try {
            return ((Set)this.getCache().keySet((Filter)Filters.always()).get()).toArray();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    @Override
    public <T1> T1[] toArray(T1[] array) {
        try {
            return ((Set)this.getCache().keySet((Filter)Filters.always()).get()).toArray(array);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    protected static class KeysAdvancer
    implements PagedIterator.Advancer {
        protected final AsyncNamedCacheClient<?, ?> f_client;
        protected boolean m_fExhausted;
        protected BytesValue m_cookie;

        protected KeysAdvancer(AsyncNamedCacheClient<?, ?> client) {
            this.f_client = client;
        }

        public void remove(Object o) {
            try {
                this.f_client.removeInternal(o).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RequestIncompleteException((Throwable)e);
            }
        }

        public Collection nextPage() {
            if (this.m_fExhausted) {
                return null;
            }
            LinkedList list = this.f_client.getKeysPage(this.m_cookie).collect(Collectors.toCollection(LinkedList::new));
            this.m_cookie = list.size() > 0 ? (BytesValue)list.poll() : null;
            this.m_fExhausted = this.m_cookie == null || this.m_cookie.getValue().isEmpty();
            return ConverterCollections.getCollection((Collection)list, this.f_client::fromBytesValue, this.f_client::toBytesValue);
        }
    }
}

