/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.client.common;

import com.oracle.coherence.grpc.client.common.AsyncNamedCacheClient;
import com.tangosol.net.RequestIncompleteException;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;

public abstract class RemoteCollection<K, V, T>
implements Collection<T> {
    protected final AsyncNamedCacheClient<K, V> f_client;

    protected RemoteCollection(AsyncNamedCacheClient<K, V> client) {
        this.f_client = client;
    }

    @Override
    public int size() {
        try {
            return this.f_client.size().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    @Override
    public boolean isEmpty() {
        try {
            return this.f_client.isEmpty().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    @Override
    public boolean add(T t) {
        throw new UnsupportedOperationException("add operations are not supported");
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException("add operations are not supported");
    }

    @Override
    public void clear() {
        try {
            this.f_client.clear().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    @Override
    public boolean containsAll(Collection<?> colKeys) {
        if (colKeys == null) {
            throw new NullPointerException("collection parameter cannot be null");
        }
        if (colKeys.isEmpty()) {
            return true;
        }
        for (Object o : colKeys) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> colKeys) {
        boolean fModified = false;
        if (this.size() > colKeys.size()) {
            for (Object colKey : colKeys) {
                fModified |= this.remove(colKey);
            }
        } else {
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                if (!colKeys.contains(iter.next())) continue;
                iter.remove();
                fModified = true;
            }
        }
        return fModified;
    }

    @Override
    public boolean retainAll(Collection<?> colKeys) {
        boolean fModified = false;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (colKeys.contains(o)) continue;
            iter.remove();
            fModified = true;
        }
        return fModified;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Collection) {
            Collection colOther = (Collection)other;
            if (colOther.size() != this.size()) {
                return false;
            }
            try {
                return this.containsAll(colOther);
            }
            catch (ClassCastException | NullPointerException unused) {
                return false;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (Object obj : this) {
            if (obj == null) continue;
            h += obj.hashCode();
        }
        return h;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(name='" + this.f_client.getCacheName() + "')";
    }

    protected AsyncNamedCacheClient<K, V> getCache() {
        return this.f_client;
    }
}

