/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.client.common;

import com.oracle.coherence.grpc.client.common.AsyncNamedCacheClient;
import com.tangosol.net.AsyncNamedCache;
import com.tangosol.net.AsyncNamedMap;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.RequestIncompleteException;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.MapListener;
import com.tangosol.util.ValueExtractor;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class NamedCacheClient<K, V>
implements NamedCache<K, V> {
    protected final AsyncNamedCacheClient<K, V> f_asyncClient;
    protected final long f_deadline;

    protected NamedCacheClient(AsyncNamedCacheClient<K, V> asyncClient) {
        this.f_asyncClient = asyncClient;
        AsyncNamedCacheClient.Dependencies dependencies = asyncClient.getDependencies();
        this.f_deadline = dependencies == null ? 30000L : Math.max(asyncClient.getDependencies().getDeadline(), 0L);
    }

    public AsyncNamedCacheClient<K, V> getAsyncClient() {
        return this.f_asyncClient;
    }

    public String toString() {
        return "NamedCacheClient{scope: \"" + this.f_asyncClient.getScopeName() + "\", name: \"" + this.f_asyncClient.getCacheName() + "\", format: \"" + this.f_asyncClient.getFormat() + "\"}";
    }

    public <T, E> void addIndex(ValueExtractor<? super T, ? extends E> valueExtractor, boolean sorted, Comparator<? super E> comparator) {
        this.f_asyncClient.assertActive();
        this.handleCompletableFuture(this.f_asyncClient.addIndex(valueExtractor, sorted, comparator));
    }

    public void addMapListener(MapListener<? super K, ? super V> mapListener) {
        this.f_asyncClient.assertActive();
        this.handleCompletableFuture(this.f_asyncClient.addMapListener(mapListener));
    }

    public void addMapListener(MapListener<? super K, ? super V> mapListener, K key, boolean lite) {
        this.f_asyncClient.assertActive();
        this.handleCompletableFuture(this.f_asyncClient.addMapListener(mapListener, (K)key, lite));
    }

    public void addMapListener(MapListener<? super K, ? super V> mapListener, Filter filter, boolean lite) {
        this.f_asyncClient.assertActive();
        CompletableFuture<Void> future = this.f_asyncClient.addMapListener(mapListener, filter, lite);
        this.handleCompletableFuture(future);
    }

    public <R> R aggregate(Collection<? extends K> keys, InvocableMap.EntryAggregator<? super K, ? super V, R> aggregator) {
        this.f_asyncClient.assertActive();
        return this.handleCompletableFuture(this.f_asyncClient.aggregate(keys, aggregator));
    }

    public <R> R aggregate(Filter filter, InvocableMap.EntryAggregator<? super K, ? super V, R> aggregator) {
        this.f_asyncClient.assertActive();
        return this.handleCompletableFuture(this.f_asyncClient.aggregate(filter, aggregator));
    }

    public void clear() {
        this.f_asyncClient.assertActive();
        this.handleCompletableFuture(this.f_asyncClient.clear());
    }

    public boolean containsKey(Object key) {
        this.f_asyncClient.assertActive();
        return this.handleCompletableFuture(this.f_asyncClient.containsKeyInternal(key));
    }

    public boolean containsValue(Object value) {
        this.f_asyncClient.assertActive();
        return this.handleCompletableFuture(this.f_asyncClient.containsValue(value));
    }

    public void destroy() {
        this.f_asyncClient.assertActive();
        this.handleCompletableFuture(this.f_asyncClient.destroy());
    }

    public Set<Map.Entry<K, V>> entrySet(Filter filter) {
        this.f_asyncClient.assertActive();
        return this.handleCompletableFuture(this.f_asyncClient.entrySet(filter));
    }

    public Set<Map.Entry<K, V>> entrySet(Filter filter, Comparator comparator) {
        this.f_asyncClient.assertActive();
        return this.handleCompletableFuture(this.f_asyncClient.entrySet(filter, comparator));
    }

    public Set<Map.Entry<K, V>> entrySet() {
        this.f_asyncClient.assertActive();
        return this.handleCompletableFuture(this.f_asyncClient.entrySet());
    }

    public V get(Object key) {
        this.f_asyncClient.assertActive();
        return this.handleCompletableFuture(this.f_asyncClient.getInternal(key, null));
    }

    public Map<K, V> getAll(Collection<? extends K> keys) {
        this.f_asyncClient.assertActive();
        return this.f_asyncClient.getAllInternalAsMap(keys);
    }

    public String getCacheName() {
        return this.f_asyncClient.getCacheName();
    }

    public CacheService getCacheService() {
        return this.f_asyncClient.getCacheService();
    }

    public <R> R invoke(K k, InvocableMap.EntryProcessor<K, V, R> entryProcessor) {
        this.f_asyncClient.assertActive();
        return this.handleCompletableFuture(this.f_asyncClient.invoke(k, entryProcessor));
    }

    public <R> Map<K, R> invokeAll(Collection<? extends K> keys, InvocableMap.EntryProcessor<K, V, R> entryProcessor) {
        this.f_asyncClient.assertActive();
        return this.handleCompletableFuture(this.f_asyncClient.invokeAll(keys, entryProcessor));
    }

    public <R> Map<K, R> invokeAll(Filter filter, InvocableMap.EntryProcessor<K, V, R> entryProcessor) {
        this.f_asyncClient.assertActive();
        return this.handleCompletableFuture(this.f_asyncClient.invokeAll(filter, entryProcessor));
    }

    public boolean isActive() {
        return this.f_asyncClient.isActiveInternal();
    }

    public boolean isReady() {
        return this.handleCompletableFuture(this.f_asyncClient.isReady());
    }

    public boolean isEmpty() {
        this.f_asyncClient.assertActive();
        return this.handleCompletableFuture(this.f_asyncClient.isEmpty());
    }

    public Set<K> keySet(Filter filter) {
        this.f_asyncClient.assertActive();
        return (Set)this.handleCompletableFuture(this.f_asyncClient.keySet(filter));
    }

    public Set<K> keySet() {
        this.f_asyncClient.assertActive();
        return this.handleCompletableFuture(this.f_asyncClient.keySet());
    }

    public boolean lock(Object o, long l) {
        throw new UnsupportedOperationException("not supported");
    }

    public boolean lock(Object o) {
        throw new UnsupportedOperationException("not supported");
    }

    public V put(K key, V value) {
        return this.put(key, value, 0L);
    }

    public V put(K key, V value, long ttl) {
        this.f_asyncClient.assertActive();
        return this.handleCompletableFuture(this.f_asyncClient.putInternal(key, value, ttl));
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        this.f_asyncClient.assertActive();
        this.handleCompletableFuture(this.f_asyncClient.putAll(m));
    }

    public void release() {
        this.f_asyncClient.assertActive();
        this.handleCompletableFuture(this.f_asyncClient.release());
    }

    public V remove(Object key) {
        this.f_asyncClient.assertActive();
        return this.handleCompletableFuture(this.f_asyncClient.removeInternal(key));
    }

    public <T, E> void removeIndex(ValueExtractor<? super T, ? extends E> valueExtractor) {
        this.f_asyncClient.assertActive();
        this.handleCompletableFuture(this.f_asyncClient.removeIndex(valueExtractor));
    }

    public void removeMapListener(MapListener<? super K, ? super V> mapListener) {
        this.f_asyncClient.assertActive();
        this.handleCompletableFuture(this.f_asyncClient.removeMapListener(mapListener));
    }

    public void removeMapListener(MapListener<? super K, ? super V> mapListener, K key) {
        this.f_asyncClient.assertActive();
        this.handleCompletableFuture(this.f_asyncClient.removeMapListener(mapListener, (K)key));
    }

    public void removeMapListener(MapListener<? super K, ? super V> mapListener, Filter filter) {
        this.f_asyncClient.assertActive();
        this.handleCompletableFuture(this.f_asyncClient.removeMapListener(mapListener, filter));
    }

    public int size() {
        this.f_asyncClient.assertActive();
        return this.handleCompletableFuture(this.f_asyncClient.size());
    }

    public boolean unlock(Object o) {
        throw new UnsupportedOperationException("Not supported");
    }

    public Collection<V> values() {
        this.f_asyncClient.assertActive();
        return this.handleCompletableFuture(this.f_asyncClient.values());
    }

    public <R> R aggregate(InvocableMap.EntryAggregator<? super K, ? super V, R> aggregator) {
        this.f_asyncClient.assertActive();
        return (R)this.handleCompletableFuture(this.f_asyncClient.aggregate(aggregator));
    }

    public AsyncNamedCache<K, V> async() {
        return this.f_asyncClient;
    }

    public AsyncNamedCache<K, V> async(AsyncNamedMap.Option ... options) {
        return this.f_asyncClient;
    }

    public V getOrDefault(Object key, V defaultValue) {
        this.f_asyncClient.assertActive();
        return this.handleCompletableFuture(this.f_asyncClient.getInternal(key, defaultValue));
    }

    public boolean isDestroyed() {
        return this.f_asyncClient.isDestroyed();
    }

    public boolean isReleased() {
        return this.f_asyncClient.isReleased();
    }

    public V putIfAbsent(K key, V value) {
        this.f_asyncClient.assertActive();
        return this.handleCompletableFuture(this.f_asyncClient.putIfAbsent(key, value));
    }

    public boolean remove(Object key, Object value) {
        this.f_asyncClient.assertActive();
        return this.handleCompletableFuture(this.f_asyncClient.removeInternal(key, value));
    }

    public boolean replace(K key, V oldValue, V newValue) {
        this.f_asyncClient.assertActive();
        return this.handleCompletableFuture(this.f_asyncClient.replace(key, oldValue, newValue));
    }

    public void truncate() {
        this.f_asyncClient.assertActive();
        this.handleCompletableFuture(this.f_asyncClient.truncate());
    }

    public Collection<V> values(Filter filter) {
        this.f_asyncClient.assertActive();
        return (Collection)this.handleCompletableFuture(this.f_asyncClient.values(filter));
    }

    public Collection<V> values(Filter filter, Comparator comparator) {
        this.f_asyncClient.assertActive();
        return this.handleCompletableFuture(this.f_asyncClient.valuesInternal(filter, comparator));
    }

    protected <T> T handleCompletableFuture(CompletableFuture<T> future) {
        return this.handleCompletableFuture(future, this.f_deadline);
    }

    protected <T> T handleCompletableFuture(CompletableFuture<T> future, long cTimeoutMillis) {
        try {
            if (cTimeoutMillis > 0L) {
                return future.get(cTimeoutMillis, TimeUnit.MILLISECONDS);
            }
            return future.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof UnsupportedOperationException) {
                throw (UnsupportedOperationException)cause;
            }
            if (cause instanceof RequestIncompleteException) {
                throw (RequestIncompleteException)cause;
            }
            if (cause == null) {
                cause = e;
            }
            throw new RequestIncompleteException(cause);
        }
        catch (InterruptedException | TimeoutException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }
}

