/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.client.common;

import com.oracle.coherence.grpc.client.common.GrpcRemoteService;
import io.grpc.Channel;
import java.util.Comparator;
import java.util.ServiceLoader;
import java.util.concurrent.locks.ReentrantLock;

public interface GrpcChannelFactory {
    public static final String RESOLVER_SCHEME = "coherence";
    public static final int PRIORITY_NORMAL = 0;

    public static GrpcChannelFactory singleton() {
        return FactoryHolder.singleton();
    }

    default public int getPriority() {
        return -1;
    }

    public Channel getChannel(GrpcRemoteService<?> var1);

    public static String createTargetURI(GrpcRemoteService<?> service) {
        String sService = service.getServiceName();
        String sScope = service.getScopeName();
        int nIdx = sService.indexOf(":");
        if (sScope == null && nIdx > 0) {
            sScope = sService.substring(0, nIdx);
            sService = sService.substring(nIdx + 1);
        }
        return GrpcChannelFactory.createTargetURI(sService, sScope);
    }

    public static String createTargetURI(String sService, String sScope) {
        if (sScope == null) {
            return "coherence://" + sService;
        }
        return "coherence://" + sService + "?" + sScope;
    }

    public static class FactoryHolder {
        private static final ReentrantLock s_lock = new ReentrantLock();
        private static volatile GrpcChannelFactory s_instance;

        private FactoryHolder() {
        }

        public static GrpcChannelFactory singleton() {
            GrpcChannelFactory factory = s_instance;
            if (factory == null) {
                s_lock.lock();
                try {
                    factory = s_instance;
                    if (factory == null) {
                        factory = s_instance = ServiceLoader.load(GrpcChannelFactory.class).stream().map(ServiceLoader.Provider::get).max(Comparator.comparingInt(GrpcChannelFactory::getPriority)).orElseThrow(() -> new IllegalStateException("No GrpcChannelFactory found on the class path"));
                    }
                }
                finally {
                    s_lock.unlock();
                }
            }
            return factory;
        }
    }
}

