/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.client.common;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.CompletableFuture;

public abstract class BaseFutureStreamObserver<T>
implements StreamObserver<T> {
    public abstract CompletableFuture future();

    public void onError(Throwable throwable) {
        CompletableFuture f = this.future();
        if (!f.isDone()) {
            StatusRuntimeException sre;
            if (throwable instanceof StatusRuntimeException && (sre = (StatusRuntimeException)throwable).getStatus().getCode() == Status.Code.UNIMPLEMENTED.toStatus().getCode()) {
                f.completeExceptionally(new UnsupportedOperationException("This operation is not supported by the current gRPC proxy. Either upgrade the version of Coherence on the gRPC proxy or connect to a gRPC proxy that supports the operation."));
                return;
            }
            f.completeExceptionally(throwable);
        }
    }
}

