/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.client.common;

import com.google.protobuf.Message;
import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.grpc.client.common.AsyncNamedCacheClient;
import com.oracle.coherence.grpc.client.common.DeactivationListener;
import com.oracle.coherence.grpc.client.common.GrpcCacheLifecycleEventDispatcher;
import com.oracle.coherence.grpc.client.common.GrpcConnection;
import com.oracle.coherence.grpc.client.common.GrpcRemoteService;
import com.oracle.coherence.grpc.client.common.NamedCacheClient;
import com.oracle.coherence.grpc.client.common.NamedCacheClientChannel;
import com.oracle.coherence.grpc.client.common.ScopedGrpcAsyncCacheReferenceStore;
import com.oracle.coherence.grpc.messages.cache.v1.NamedCacheResponse;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.internal.net.NamedCacheDeactivationListener;
import com.tangosol.internal.net.grpc.RemoteGrpcCacheServiceDependencies;
import com.tangosol.net.BackingMapManager;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.events.EventDispatcher;
import com.tangosol.net.events.EventDispatcherRegistry;
import com.tangosol.util.AbstractMapListener;
import com.tangosol.util.IteratorEnumerator;
import com.tangosol.util.MapEvent;
import com.tangosol.util.ResourceRegistry;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.concurrent.Executor;
import java.util.function.IntPredicate;

public class GrpcRemoteCacheService
extends GrpcRemoteService<RemoteGrpcCacheServiceDependencies>
implements CacheService {
    private final ClientDeactivationListener f_deactivationListener = new ClientDeactivationListener();
    private final TruncateListener f_truncateListener = new TruncateListener();
    private BackingMapManager m_backingMapManager;
    private final ScopedGrpcAsyncCacheReferenceStore m_scopedCacheStore = new ScopedGrpcAsyncCacheReferenceStore();

    public GrpcRemoteCacheService() {
        super("RemoteGrpcCache");
    }

    @Override
    protected Class<? extends Message> getResponseType() {
        return NamedCacheResponse.class;
    }

    public BackingMapManager getBackingMapManager() {
        return this.m_backingMapManager;
    }

    public void setBackingMapManager(BackingMapManager manager) {
        this.m_backingMapManager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamedCache ensureCache(String sName, ClassLoader ignored) {
        ClassLoader loader = this.getContextClassLoader();
        if (loader == null) {
            throw new IllegalStateException("ContextClassLoader is missing");
        }
        AsyncNamedCacheClient cache = (AsyncNamedCacheClient)this.m_scopedCacheStore.get(sName, loader);
        if (cache == null || !cache.isActiveInternal()) {
            long cWait = ((RemoteGrpcCacheServiceDependencies)this.getDependencies()).getRequestTimeoutMillis();
            if (cWait <= 0L) {
                cWait = -1L;
            }
            if (!this.m_scopedCacheStore.lock(sName, cWait)) {
                throw new RequestTimeoutException("Failed to get a reference to cache '" + sName + "' after " + cWait + "ms");
            }
            try {
                cache = (AsyncNamedCacheClient)this.m_scopedCacheStore.get(sName, loader);
                if (cache == null || !cache.isActiveInternal()) {
                    cache = this.ensureAsyncCache(sName);
                    this.m_scopedCacheStore.put(cache, loader);
                }
            }
            finally {
                this.m_scopedCacheStore.unlock(sName);
            }
        }
        return cache.getNamedCache();
    }

    public Enumeration getCacheNames() {
        return new IteratorEnumerator(Arrays.asList(this.m_scopedCacheStore.getNames().toArray()).iterator());
    }

    public void releaseCache(NamedCache map) {
        if (!(map instanceof NamedCacheClient)) {
            throw new IllegalArgumentException("illegal map: " + String.valueOf(map));
        }
        map.release();
        NamedCacheClient cache = (NamedCacheClient)map;
        this.m_scopedCacheStore.release(cache.getAsyncClient());
    }

    public void destroyCache(NamedCache map) {
        if (!(map instanceof NamedCacheClient)) {
            throw new IllegalArgumentException("illegal map: " + String.valueOf(map));
        }
        map.destroy();
        NamedCacheClient cache = (NamedCacheClient)map;
        this.m_scopedCacheStore.release(cache.getAsyncClient());
    }

    public boolean isVersionCompatible(int nMajor, int nMinor, int nMicro, int nPatchSet, int nPatch) {
        int nEncoded = ServiceMemberSet.encodeVersion((int)nMajor, (int)nMinor, (int)nMicro, (int)nPatchSet, (int)nPatch);
        return CacheFactory.VERSION_ENCODED >= nEncoded;
    }

    public boolean isVersionCompatible(int nYear, int nMonth, int nPatch) {
        int nEncoded = ServiceMemberSet.encodeVersion((int)nYear, (int)nMonth, (int)nPatch);
        return CacheFactory.VERSION_ENCODED >= nEncoded;
    }

    public boolean isVersionCompatible(int nVersion) {
        return CacheFactory.VERSION_ENCODED >= nVersion;
    }

    public boolean isVersionCompatible(IntPredicate predicate) {
        return predicate.test(CacheFactory.VERSION_ENCODED);
    }

    public int getMinimumServiceVersion() {
        return CacheFactory.VERSION_ENCODED;
    }

    public boolean isDeferKeyAssociationCheck() {
        return ((RemoteGrpcCacheServiceDependencies)this.getDependencies()).isDeferKeyAssociationCheck();
    }

    @Override
    protected void stopInternal() {
        for (AsyncNamedCacheClient cache : this.m_scopedCacheStore.getAll()) {
            cache.removeDeactivationListener(this.f_deactivationListener);
            try {
                cache.release();
            }
            catch (Throwable e) {
                Logger.err((Throwable)e);
            }
        }
    }

    @Override
    protected EventDispatcherRegistry getDefaultEventDispatcherRegistry() {
        ResourceRegistry registry = this.getBackingMapManager().getCacheFactory().getResourceRegistry();
        return (EventDispatcherRegistry)registry.getResource(EventDispatcherRegistry.class);
    }

    protected <K, V> AsyncNamedCacheClient<K, V> ensureAsyncCache(String sCacheName) {
        GrpcCacheLifecycleEventDispatcher dispatcher = new GrpcCacheLifecycleEventDispatcher(sCacheName, this);
        Channel channel = this.m_tracingInterceptor == null ? this.m_channel : ClientInterceptors.intercept((Channel)this.m_channel, (ClientInterceptor[])new ClientInterceptor[]{this.m_tracingInterceptor});
        AsyncNamedCacheClient.Dependencies dependencies = this.createCacheDependencies(sCacheName, channel, dispatcher);
        GrpcConnection connection = this.connect("CacheService", 1, 1);
        NamedCacheClientChannel protocol = NamedCacheClientChannel.createProtocol(dependencies, connection);
        AsyncNamedCacheClient client = new AsyncNamedCacheClient(dependencies, protocol);
        EventDispatcherRegistry dispatcherReg = this.getEventDispatcherRegistry();
        if (dispatcherReg != null) {
            dispatcherReg.registerEventDispatcher((EventDispatcher)dispatcher);
        }
        client.setCacheService(this);
        client.addDeactivationListener(this.f_truncateListener);
        client.addDeactivationListener(this.f_deactivationListener);
        this.m_executor.execute(() -> dispatcher.dispatchCacheCreated(client.getNamedCache()));
        return client;
    }

    private AsyncNamedCacheClient.Dependencies createCacheDependencies(String sCacheName, Channel channel, GrpcCacheLifecycleEventDispatcher dispatcher) {
        RemoteGrpcCacheServiceDependencies dependencies = (RemoteGrpcCacheServiceDependencies)this.getDependencies();
        String sScopeName = dependencies.getRemoteScopeName();
        if (sScopeName == null) {
            sScopeName = "";
        }
        AsyncNamedCacheClient.DefaultDependencies deps = new AsyncNamedCacheClient.DefaultDependencies(sCacheName, channel, dispatcher);
        deps.setScope(sScopeName);
        deps.setSerializer(this.m_serializer, this.m_serializer.getName());
        deps.setExecutor((Executor)this.m_executor);
        deps.setDeferKeyAssociationCheck(dependencies.isDeferKeyAssociationCheck());
        deps.setDeadline(dependencies.getDeadline());
        deps.setHeartbeatMillis(dependencies.getHeartbeatInterval());
        deps.setRequireHeartbeatAck(dependencies.isRequireHeartbeatAck());
        return deps;
    }

    private class ClientDeactivationListener<K, V>
    implements DeactivationListener<AsyncNamedCacheClient<? super K, ? super V>> {
        private ClientDeactivationListener() {
        }

        @Override
        public void released(AsyncNamedCacheClient<? super K, ? super V> client) {
            GrpcRemoteCacheService.this.m_scopedCacheStore.remove(client.getCacheName());
        }

        @Override
        public void destroyed(AsyncNamedCacheClient<? super K, ? super V> client) {
            GrpcRemoteCacheService service = GrpcRemoteCacheService.this;
            boolean removed = service.m_scopedCacheStore.release(client);
            if (removed) {
                GrpcCacheLifecycleEventDispatcher dispatcher = client.getEventDispatcher();
                EventDispatcherRegistry dispatcherReg = service.getEventDispatcherRegistry();
                dispatcher.dispatchCacheDestroyed(client.getNamedCache());
                dispatcherReg.unregisterEventDispatcher((EventDispatcher)client.getEventDispatcher());
            }
        }
    }

    private class TruncateListener
    extends AbstractMapListener
    implements NamedCacheDeactivationListener {
        private TruncateListener() {
        }

        public void entryUpdated(MapEvent evt) {
            NamedCache cache = (NamedCache)evt.getMap();
            AsyncNamedCacheClient client = (AsyncNamedCacheClient)GrpcRemoteCacheService.this.m_scopedCacheStore.get(cache.getCacheName(), TruncateListener.getContextClassLoader());
            if (client != null) {
                client.getEventDispatcher().dispatchCacheTruncated((NamedCache)evt.getMap());
            }
        }
    }
}

