/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.discovery;

import com.tangosol.discovery.Connection;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.remote.JMXServiceURL;

public class NSLookup {
    public static final String COMMAND_HELP = "?";
    public static final String COMMAND_HOST = "host";
    public static final String COMMAND_LOCAL = "local";
    public static final String COMMAND_TTL = "ttl";
    public static final String COMMAND_PORT = "port";
    public static final String COMMAND_TIMEOUT = "timeout";
    public static final String COMMAND_CLUSTER = "cluster";
    public static final String COMMAND_NAME = "name";
    public static final String[] VALID_COMMANDS = new String[]{"?", "host", "local", "ttl", "cluster", "port", "timeout", "name"};
    public static final String NS_STRING_PREFIX = "NameService/string/";
    public static final String JMX_CONNECTOR_URL = "management/JMXServiceURL";
    public static final String HTTP_MANAGEMENT_URL = "management/HTTPManagementURL";
    public static final String HTTP_METRICS_URL = "metrics/HTTPMetricsURL";
    public static final String HTTP_HEALTH_URL = "health/HTTPHealthURL";
    public static final String CLUSTER_INFO = "Cluster/info";
    public static final String GRPC_PROXY_URL = "$GRPC:GrpcProxy";
    public static final String[] VALID_PREDEFINED_LOOKUP_NAMES = new String[]{"management/JMXServiceURL", "management/HTTPManagementURL", "metrics/HTTPMetricsURL", "health/HTTPHealthURL", "$GRPC:GrpcProxy", "Cluster/info"};
    public static final int DEFAULT_TIMEOUT = 5000;
    public static final int DEFAULT_CLUSTERPORT = 7574;
    public static final String DEFAULT_HOST = "239.192.0.0";
    public static final int DEFAULT_TTL = 4;
    public static final String DEFAULT_NAME = "Cluster/info";

    public static JMXServiceURL lookupJMXServiceURL(SocketAddress socketAddr) throws IOException {
        return NSLookup.lookupJMXServiceURL(null, socketAddr);
    }

    public static JMXServiceURL lookupJMXServiceURL(String sCluster, SocketAddress socketAddr) throws IOException {
        String sURL = NSLookup.lookup(sCluster, JMX_CONNECTOR_URL, socketAddr, 5000);
        return sURL == null ? null : new JMXServiceURL(sURL);
    }

    public static Collection<URL> lookupHTTPManagementURL(SocketAddress socketAddr) throws IOException {
        return NSLookup.lookupHTTPManagementURL(null, socketAddr);
    }

    public static Collection<URL> lookupHTTPManagementURL(String sCluster, SocketAddress socketAddr) throws IOException {
        return NSLookup.lookupURL(sCluster, socketAddr, "NameService/string/management/HTTPManagementURL");
    }

    public static Collection<URL> lookupHTTPMetricsURL(SocketAddress socketAddr) throws IOException {
        return NSLookup.lookupHTTPMetricsURL(null, socketAddr);
    }

    public static Collection<URL> lookupHTTPMetricsURL(String sCluster, SocketAddress socketAddr) throws IOException {
        return NSLookup.lookupURL(sCluster, socketAddr, "NameService/string/metrics/HTTPMetricsURL");
    }

    public static Collection<URL> lookupHTTPHealthURL(SocketAddress socketAddr) throws IOException {
        return NSLookup.lookupHTTPHealthURL(null, socketAddr);
    }

    public static Collection<URL> lookupHTTPHealthURL(String sCluster, SocketAddress socketAddr) throws IOException {
        return NSLookup.lookupURL(sCluster, socketAddr, "NameService/string/health/HTTPHealthURL");
    }

    public static Collection<SocketAddress> lookupGrpcProxy(SocketAddress socketAddr) throws IOException {
        return NSLookup.lookupGrpcProxy(null, socketAddr);
    }

    public static Collection<SocketAddress> lookupGrpcProxy(String sCluster, SocketAddress socketAddr) throws IOException {
        String sName = "NameService/string/$GRPC:GrpcProxy";
        String sResult = NSLookup.lookup(sCluster, sName, socketAddr, 5000);
        String[] asResult = sResult == null ? null : sResult.split("[\\[,\\] ]+");
        ArrayList<SocketAddress> list = new ArrayList<SocketAddress>();
        if (asResult != null) {
            for (int i = 1; i < asResult.length; i += 2) {
                list.add(new InetSocketAddress(asResult[i], Integer.parseInt(asResult[i + 1])));
            }
        }
        return list;
    }

    public static Collection<SocketAddress> lookupExtendProxy(SocketAddress socketAddr, String sName) throws IOException {
        return NSLookup.lookupExtendProxy(null, socketAddr, sName);
    }

    public static Collection<SocketAddress> lookupExtendProxy(String sCluster, SocketAddress socketAddr, String sName) throws IOException {
        String[] asResult;
        ArrayList<SocketAddress> list = new ArrayList<SocketAddress>();
        String sResult = NSLookup.lookup(sCluster, NS_STRING_PREFIX + sName, socketAddr, 5000);
        String[] stringArray = asResult = sResult == null ? null : sResult.split("[\\[,\\] ]+");
        if (asResult != null) {
            for (int i = 1; i < asResult.length; i += 2) {
                list.add(new InetSocketAddress(asResult[i], Integer.parseUnsignedInt(asResult[i + 1])));
            }
        }
        return list;
    }

    private static Collection<URL> lookupURL(String sCluster, SocketAddress socketAddr, String sName) throws IOException {
        String[] asURL;
        ArrayList<URL> colUrl = new ArrayList<URL>();
        String sURL = NSLookup.lookup(sCluster, sName, socketAddr, 5000);
        String[] stringArray = asURL = sURL == null ? null : sURL.split("[\\[,\\] ]+");
        if (asURL != null) {
            for (int i = 1; i < asURL.length; ++i) {
                colUrl.add(new URL(asURL[i]));
            }
        }
        return colUrl;
    }

    public static String lookup(String sName, SocketAddress socketAddr, int cTimeOutMillis) throws IOException {
        try (Connection connection = new Connection(socketAddr, cTimeOutMillis);){
            String string = connection.lookup(sName);
            return string;
        }
    }

    public static String lookup(String sCluster, String sName, SocketAddress socketAddr, int cTimeOutMillis) throws IOException {
        try (Connection conn = Connection.open(sCluster, socketAddr, cTimeOutMillis);){
            String string = conn.lookup(sName);
            return string;
        }
    }

    protected static void write(DataOutputStream outStream, byte[] ab) throws IOException {
        int cb = ab.length;
        NSLookup.writePackedInt(outStream, cb);
        outStream.write(ab, 0, cb);
    }

    protected static byte[] read(DataInputStream inStream) throws IOException {
        int cb = NSLookup.readPackedInt(inStream);
        if (cb < 0) {
            throw new IOException("Received a message with a negative length");
        }
        if (cb == 0) {
            throw new IOException("Received a message with a length of zero");
        }
        byte[] ab = new byte[cb];
        inStream.readFully(ab);
        return ab;
    }

    protected static void writePackedInt(DataOutputStream outStream, int n) throws IOException {
        int b = 0;
        if (n < 0) {
            b = 64;
            n ^= 0xFFFFFFFF;
        }
        b |= (byte)(n & 0x3F);
        n >>>= 6;
        while (n != 0) {
            outStream.writeByte(b |= 0x80);
            b = n & 0x7F;
            n >>>= 7;
        }
        outStream.writeByte(b);
    }

    protected static int readPackedInt(DataInputStream inStream) throws IOException {
        boolean fNeg;
        int b = inStream.readUnsignedByte();
        int n = b & 0x3F;
        int cBits = 6;
        boolean bl = fNeg = (b & 0x40) != 0;
        while ((b & 0x80) != 0) {
            b = inStream.readUnsignedByte();
            n |= (b & 0x7F) << cBits;
            cBits += 7;
        }
        if (fNeg) {
            n ^= 0xFFFFFFFF;
        }
        return n;
    }

    protected static String validateCommand(String sCommand, String[] asCommand, boolean fCaseSens) {
        if (!fCaseSens) {
            sCommand = sCommand.toLowerCase();
        }
        if (asCommand == null) {
            return sCommand;
        }
        for (int i = 0; i < asCommand.length; ++i) {
            if (!asCommand[i].equals(sCommand)) continue;
            return sCommand;
        }
        throw new IllegalArgumentException("Illegal command: -" + sCommand);
    }

    public static LinkedHashMap parseArguments(String[] asArg, String[] asCommand, boolean fCaseSens) {
        LinkedHashMap<Object, String> map = new LinkedHashMap<Object, String>();
        String sCommand = null;
        int iArg = -1;
        for (int i = 0; i < asArg.length; ++i) {
            String sArg = asArg[i];
            if (sArg.charAt(0) == '-') {
                if (sCommand != null) {
                    map.put(sCommand, null);
                }
                if ((sCommand = sArg.substring(1)).length() == 0) {
                    throw new IllegalArgumentException("An empty command");
                }
                int of = sCommand.indexOf(61);
                if (of < 0) {
                    of = sCommand.indexOf(58);
                }
                if (of > 0) {
                    String sValue = sCommand.substring(of + 1);
                    sCommand = NSLookup.validateCommand(sCommand.substring(0, of), asCommand, fCaseSens);
                    map.put(sCommand, sValue);
                    sCommand = null;
                    continue;
                }
                sCommand = NSLookup.validateCommand(sCommand, asCommand, fCaseSens);
                continue;
            }
            if (sCommand == null) {
                map.put(++iArg, sArg);
                continue;
            }
            map.put(sCommand, sArg);
            sCommand = null;
        }
        if (sCommand != null) {
            map.put(sCommand, null);
        }
        return map;
    }

    public static void datagramLookupRaw(String sCluster, String sName, InetSocketAddress addrGroup, InetAddress addrLocal, int cTimeoutMillis, int nTTL, byte[] abMemberClient, BiConsumer<String, DataInputStream> consumerResult) throws IOException {
        HashSet<String> setCluster = new HashSet<String>();
        try (MulticastSocket socket = new MulticastSocket();){
            int cAttempts;
            byte[] abAddrThis = addrLocal == null || addrLocal.isAnyLocalAddress() ? null : addrLocal.getAddress();
            ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(outBytes);
            int cDelayMillis = 200;
            if (cTimeoutMillis == 0) {
                cAttempts = Integer.MAX_VALUE;
            } else {
                cDelayMillis = Math.min(cTimeoutMillis, cDelayMillis);
                cAttempts = cTimeoutMillis / cDelayMillis;
            }
            out.writeInt(232718554);
            out.writeUTF(sCluster == null ? "" : sCluster);
            out.flush();
            int ofAttempt = outBytes.size();
            out.writeByte(0);
            out.writeByte(cAttempts);
            if (abAddrThis == null) {
                out.writeByte(0);
                out.writeInt(0);
            } else {
                out.writeByte(abAddrThis.length);
                out.write(abAddrThis);
                out.writeInt(socket.getLocalPort());
                socket.setInterface(addrLocal);
            }
            out.writeUTF(sName);
            if (abMemberClient == null) {
                out.writeInt(0);
            } else {
                out.writeInt(abMemberClient.length);
                out.write(abMemberClient);
            }
            out.flush();
            byte[] abReq = outBytes.toByteArray();
            DatagramPacket packetReq = new DatagramPacket(abReq, 0, abReq.length);
            packetReq.setSocketAddress(addrGroup);
            socket.setSoTimeout(cDelayMillis);
            socket.setTimeToLive(nTTL);
            byte[] abResp = new byte[65535];
            DatagramPacket packetResp = new DatagramPacket(abResp, 0, abResp.length);
            int n = ofAttempt;
            abReq[n] = (byte)(abReq[n] + 1);
            socket.send(packetReq);
            do {
                try {
                    if (Thread.interrupted()) {
                        throw new InterruptedIOException();
                    }
                    socket.receive(packetResp);
                    DataInputStream in = new DataInputStream(new ByteArrayInputStream(abResp));
                    if (in.readInt() == 232718554) {
                        String sClusterResult = in.readUTF();
                        if (sCluster == null || sCluster.equals(sClusterResult)) {
                            in.read();
                            in.read();
                            byte cbAddr = in.readByte();
                            byte[] abAddr = new byte[cbAddr];
                            in.readFully(abAddr);
                            in.readInt();
                            if (sName.equals(in.readUTF()) && setCluster.add(sClusterResult)) {
                                in.mark(4);
                                int cbResult = in.readInt();
                                in.reset();
                                if (cbResult == -1) {
                                    InetAddress addrTcp = InetAddress.getByAddress(abAddr);
                                    try (Connection conn = Connection.open(sClusterResult, new InetSocketAddress(addrTcp, addrGroup.getPort()), cTimeoutMillis);){
                                        consumerResult.accept(sClusterResult, conn.lookupRaw(sName));
                                    }
                                } else {
                                    consumerResult.accept(sClusterResult, in);
                                }
                                if (sCluster != null) {
                                    return;
                                }
                            }
                        }
                    }
                }
                catch (SocketTimeoutException e) {
                    --cAttempts;
                    int n2 = ofAttempt;
                    abReq[n2] = (byte)(abReq[n2] + 1);
                    if (abReq[ofAttempt] == 0) {
                        abReq[ofAttempt] = 1;
                    }
                    socket.send(packetReq);
                }
            } while (cAttempts > 0);
        }
        if (setCluster.isEmpty()) {
            throw new IOException((String)(sCluster == null ? "no cluster could be located" : "cluster '" + sCluster + "' could not be located"));
        }
    }

    public static DataInputStream datagramLookupRaw(String sCluster, String sName, InetSocketAddress addrGroup, InetAddress addrLocal, int cTimeoutMillis, int nTTL, byte[] abMemberClient) throws IOException {
        final AtomicReference refResult = new AtomicReference();
        NSLookup.datagramLookupRaw(sCluster, sName, addrGroup, addrLocal, cTimeoutMillis, nTTL, abMemberClient, new BiConsumer<String, DataInputStream>(){

            @Override
            public void accept(String t, DataInputStream in) {
                refResult.set(in);
            }
        });
        return (DataInputStream)refResult.get();
    }

    public static void datagramLookup(String sCluster, String sName, InetSocketAddress addrGroup, InetAddress addrLocal, int cTimeoutMillis, int nTTL, byte[] abMemberClient, final BiConsumer<String, String> consumerResult) throws IOException {
        NSLookup.datagramLookupRaw(sCluster, sName, addrGroup, addrLocal, cTimeoutMillis, nTTL, abMemberClient, new BiConsumer<String, DataInputStream>(){

            @Override
            public void accept(String sCluster1, DataInputStream in) {
                consumerResult.accept(sCluster1, NSLookup.readString(in));
            }
        });
    }

    public static String readString(DataInputStream in) {
        try {
            int cbResult = in.readInt();
            if (cbResult == 0) {
                return null;
            }
            in.readShort();
            byte[] abResult = new byte[NSLookup.readPackedInt(in)];
            in.readFully(abResult);
            return new String(abResult);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] asArg) throws IOException {
        int cTimeoutMillis;
        int nTTL;
        int nPort;
        String sName;
        String sCluster;
        String sLocal;
        String sHost;
        try {
            String sPort;
            LinkedHashMap mapArgs = NSLookup.parseArguments(asArg, VALID_COMMANDS, true);
            sHost = (String)mapArgs.remove(COMMAND_HOST);
            sLocal = (String)mapArgs.remove(COMMAND_LOCAL);
            sCluster = (String)mapArgs.remove(COMMAND_CLUSTER);
            sName = (String)mapArgs.remove(COMMAND_NAME);
            if (sName == null) {
                sName = "Cluster/info";
            }
            if (sHost == null) {
                sHost = DEFAULT_HOST;
            }
            nPort = (sPort = (String)mapArgs.remove(COMMAND_PORT)) == null ? 7574 : Integer.parseInt(sPort);
            String sTTL = (String)mapArgs.remove(COMMAND_TTL);
            nTTL = sTTL == null ? 4 : Integer.parseInt(sTTL);
            String sTimeoutSec = (String)mapArgs.remove(COMMAND_TIMEOUT);
            int n = cTimeoutMillis = sTimeoutSec == null ? 5000 : Integer.parseInt(sTimeoutSec) * 1000;
            if (!mapArgs.isEmpty()) {
                NSLookup.showInstructions();
                System.exit(1);
            }
        }
        catch (Throwable e) {
            System.err.println(e);
            System.err.println();
            NSLookup.showInstructions();
            System.exit(1);
            return;
        }
        Throwable ex = null;
        HashSet<InetAddress> setAddr = new HashSet<InetAddress>();
        if (sHost.equals("localhost")) {
            Enumeration<NetworkInterface> iterNics = NetworkInterface.getNetworkInterfaces();
            while (iterNics.hasMoreElements()) {
                Enumeration<InetAddress> iterAddr = iterNics.nextElement().getInetAddresses();
                while (iterAddr.hasMoreElements()) {
                    setAddr.add(iterAddr.nextElement());
                }
            }
        } else {
            Collections.addAll(setAddr, InetAddress.getAllByName(sHost));
        }
        for (InetAddress address : setAddr) {
            try {
                block28: {
                    InetSocketAddress socketAddr = new InetSocketAddress(address, nPort);
                    if (address.isMulticastAddress()) {
                        final String sClusterSearch = sCluster;
                        NSLookup.datagramLookup(sClusterSearch, NS_STRING_PREFIX + sName, socketAddr, sLocal == null ? null : InetAddress.getByName(sLocal), cTimeoutMillis, nTTL, null, new BiConsumer<String, String>(){

                            @Override
                            public void accept(String sClusterFound, String sResult) {
                                System.out.println((String)(sClusterSearch == null ? "Cluster " + sClusterFound + ":\t" + sResult : sResult));
                            }
                        });
                        continue;
                    }
                    try (Connection conn = Connection.open(sCluster, socketAddr, cTimeoutMillis);){
                        if (sCluster == null) {
                            StringTokenizer sTok = new StringTokenizer(conn.lookup("Cluster/name") + "," + conn.lookup("NameService/string/Cluster/foreign"), "[,]");
                            while (sTok.hasMoreElements()) {
                                sCluster = sTok.nextToken().trim();
                                Connection conn2 = Connection.open(sCluster, socketAddr, cTimeoutMillis);
                                try {
                                    String sResultLookup = conn2.lookup(NS_STRING_PREFIX + sName);
                                    System.out.println("Cluster " + sCluster + ":\t" + sResultLookup);
                                    if (sResultLookup != null) continue;
                                    NSLookup.reportNameWarning(sName);
                                }
                                finally {
                                    if (conn2 == null) continue;
                                    conn2.close();
                                }
                            }
                            break block28;
                        }
                        String sResultLookup = conn.lookup(NS_STRING_PREFIX + sName);
                        System.out.println(sResultLookup);
                        if (sResultLookup == null) {
                            NSLookup.reportNameWarning(sName);
                        }
                    }
                }
                ex = null;
                break;
            }
            catch (IOException ioe) {
                ex = ioe;
            }
        }
        if (ex != null) {
            String sMsg = ex.getMessage();
            System.err.println("Error: " + (sMsg == null ? ex.getClass().getSimpleName() : sMsg) + "; while querying " + sHost + ":" + nPort + " for " + sName);
            System.exit(1);
        }
    }

    protected static void showInstructions() {
        String sClass = NSLookup.class.getCanonicalName();
        StringBuffer sbLookupNames = new StringBuffer("Valid predefined lookup names for -name option: ");
        for (String sName : VALID_PREDEFINED_LOOKUP_NAMES) {
            sbLookupNames.append(" " + sName + ",");
        }
        sbLookupNames.setCharAt(sbLookupNames.length() - 1, '.');
        System.out.println();
        System.out.println("java " + sClass + " <commands ...>");
        System.out.println();
        System.out.println("command options:");
        System.out.println("\t-host    the cluster address (unicast or multicast); default 239.192.0.0");
        System.out.println("\t-local   the local IP to issue the request on when using multicast");
        System.out.println("\t-ttl     the TTL for multicast; default 4");
        System.out.println("\t-cluster the cluster; optional");
        System.out.println("\t-name    the name to lookup from the NameService; default Cluster/info");
        System.out.println("\t-port    the cluster port; default 7574");
        System.out.println("\t-timeout the timeout (in seconds) of the lookup request; default 5");
        System.out.println();
        System.out.println(sbLookupNames.toString());
        System.out.println();
        System.out.println("Example:");
        System.out.println("\tjava " + sClass + " -host host.mycompany.com -name management/JMXServiceURL");
        System.out.println();
    }

    protected static String validateName(String sName) {
        for (String s : VALID_PREDEFINED_LOOKUP_NAMES) {
            if (!s.equals(sName)) continue;
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("Warning: provided -name parameter of \"" + sName + "\"");
        sb.append(" does not match predefined Name Service lookups of ");
        for (int i = 0; i < VALID_PREDEFINED_LOOKUP_NAMES.length; ++i) {
            sb.append("\"" + VALID_PREDEFINED_LOOKUP_NAMES[i] + "\"");
            if (i + 1 < VALID_PREDEFINED_LOOKUP_NAMES.length) {
                sb.append(",");
                continue;
            }
            sb.append(".");
        }
        sb.append(System.lineSeparator());
        sb.append("warning: If looking up an extend proxy service, verify the scoped proxy service name is correct.");
        return sb.toString();
    }

    protected static void reportNameWarning(String sName) {
        String sWarning = NSLookup.validateName(sName);
        if (sWarning != null) {
            System.err.println(sWarning);
        }
    }

    public static interface BiConsumer<T, U> {
        public void accept(T var1, U var2);
    }
}

