/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor;

import com.oracle.coherence.concurrent.executor.ExecutionStrategy;
import com.oracle.coherence.concurrent.executor.StandardExecutionStrategy;
import com.oracle.coherence.concurrent.executor.TaskExecutorService;
import com.oracle.coherence.concurrent.executor.function.Predicates;
import com.tangosol.util.function.Remote;

public class ExecutionStrategyBuilder {
    protected int m_cLimit = -1;
    protected Remote.Predicate<? super TaskExecutorService.ExecutorInfo> m_predicate = Predicates.always();
    protected boolean m_fConcurrentExecution = true;

    public ExecutionStrategy build() {
        return new StandardExecutionStrategy(this.m_cLimit, this.m_predicate, this.m_fConcurrentExecution);
    }

    public ExecutionStrategyBuilder limit(int n) {
        this.m_cLimit = n < 0 ? -1 : n;
        return this;
    }

    public ExecutionStrategyBuilder filter(Remote.Predicate<? super TaskExecutorService.ExecutorInfo> predicate) {
        this.m_predicate = predicate == null ? Predicates.always() : predicate;
        return this;
    }

    public ExecutionStrategyBuilder sequentially() {
        this.m_fConcurrentExecution = false;
        return this;
    }

    public ExecutionStrategyBuilder concurrently() {
        this.m_fConcurrentExecution = true;
        return this;
    }
}

