/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.atomic;

import com.oracle.coherence.concurrent.atomic.LocalAtomicBoolean;
import com.oracle.coherence.concurrent.atomic.LocalAtomicInteger;
import com.oracle.coherence.concurrent.atomic.LocalAtomicLong;
import com.oracle.coherence.concurrent.atomic.LocalAtomicMarkableReference;
import com.oracle.coherence.concurrent.atomic.LocalAtomicReference;
import com.oracle.coherence.concurrent.atomic.LocalAtomicStampedReference;
import com.oracle.coherence.concurrent.atomic.RemoteAtomicBoolean;
import com.oracle.coherence.concurrent.atomic.RemoteAtomicInteger;
import com.oracle.coherence.concurrent.atomic.RemoteAtomicLong;
import com.oracle.coherence.concurrent.atomic.RemoteAtomicMarkableReference;
import com.oracle.coherence.concurrent.atomic.RemoteAtomicReference;
import com.oracle.coherence.concurrent.atomic.RemoteAtomicStampedReference;
import com.oracle.coherence.concurrent.config.ConcurrentServicesSessionConfiguration;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.net.Coherence;
import com.tangosol.net.NamedMap;
import com.tangosol.net.Session;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicMarkableReference;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicStampedReference;

public final class Atomics {
    public static final String SESSION_NAME = ConcurrentServicesSessionConfiguration.SESSION_NAME;
    private static final Map<String, LocalAtomicBoolean> LOCAL_BOOLEANS = new ConcurrentHashMap<String, LocalAtomicBoolean>();
    private static final Map<String, LocalAtomicInteger> LOCAL_INTS = new ConcurrentHashMap<String, LocalAtomicInteger>();
    private static final Map<String, LocalAtomicLong> LOCAL_LONGS = new ConcurrentHashMap<String, LocalAtomicLong>();
    private static final Map<String, LocalAtomicReference> LOCAL_REFS = new ConcurrentHashMap<String, LocalAtomicReference>();
    private static final Map<String, LocalAtomicMarkableReference> LOCAL_MARKABLE_REFS = new ConcurrentHashMap<String, LocalAtomicMarkableReference>();
    private static final Map<String, LocalAtomicStampedReference> LOCAL_STAMPED_REFS = new ConcurrentHashMap<String, LocalAtomicStampedReference>();

    private Atomics() {
    }

    public static LocalAtomicBoolean localAtomicBoolean(String sName) {
        return Atomics.localAtomicBoolean(sName, false);
    }

    public static LocalAtomicBoolean localAtomicBoolean(String sName, boolean fInitialValue) {
        return LOCAL_BOOLEANS.computeIfAbsent(sName, name -> new LocalAtomicBoolean(fInitialValue));
    }

    public static RemoteAtomicBoolean remoteAtomicBoolean(String sName) {
        return Atomics.remoteAtomicBoolean(sName, false);
    }

    public static RemoteAtomicBoolean remoteAtomicBoolean(String sName, boolean fInitialValue) {
        NamedMap map = Atomics.atomics().getMap("atomic-boolean", new NamedMap.Option[0]);
        map.putIfAbsent((Object)sName, (Object)new AtomicBoolean(fInitialValue));
        return new RemoteAtomicBoolean((NamedMap<String, AtomicBoolean>)map, sName);
    }

    public static LocalAtomicInteger localAtomicInteger(String sName) {
        return Atomics.localAtomicInteger(sName, 0);
    }

    public static LocalAtomicInteger localAtomicInteger(String sName, int nInitialValue) {
        return LOCAL_INTS.computeIfAbsent(sName, name -> new LocalAtomicInteger(nInitialValue));
    }

    public static RemoteAtomicInteger remoteAtomicInteger(String sName) {
        return Atomics.remoteAtomicInteger(sName, 0);
    }

    public static RemoteAtomicInteger remoteAtomicInteger(String sName, int nInitialValue) {
        NamedMap map = Atomics.atomics().getMap("atomic-int", new NamedMap.Option[0]);
        map.putIfAbsent((Object)sName, (Object)new AtomicInteger(nInitialValue));
        return new RemoteAtomicInteger((NamedMap<String, AtomicInteger>)map, sName);
    }

    public static LocalAtomicLong localAtomicLong(String sName) {
        return Atomics.localAtomicLong(sName, 0L);
    }

    public static LocalAtomicLong localAtomicLong(String sName, long lInitialValue) {
        return LOCAL_LONGS.computeIfAbsent(sName, name -> new LocalAtomicLong(lInitialValue));
    }

    public static RemoteAtomicLong remoteAtomicLong(String sName) {
        return Atomics.remoteAtomicLong(sName, 0L);
    }

    public static RemoteAtomicLong remoteAtomicLong(String sName, long lInitialValue) {
        NamedMap map = Atomics.atomics().getMap("atomic-long", new NamedMap.Option[0]);
        map.putIfAbsent((Object)sName, (Object)new AtomicLong(lInitialValue));
        return new RemoteAtomicLong((NamedMap<String, AtomicLong>)map, sName);
    }

    public static <V> LocalAtomicReference<V> localAtomicReference(String sName) {
        return Atomics.localAtomicReference(sName, null);
    }

    public static <V> LocalAtomicReference<V> localAtomicReference(String sName, V initialValue) {
        return LOCAL_REFS.computeIfAbsent(sName, name -> new LocalAtomicReference<Object>(initialValue));
    }

    public static <V> RemoteAtomicReference<V> remoteAtomicReference(String sName) {
        return Atomics.remoteAtomicReference(sName, null);
    }

    public static <V> RemoteAtomicReference<V> remoteAtomicReference(String sName, V initialValue) {
        NamedMap refs = Atomics.atomics().getMap("atomic-ref", new NamedMap.Option[0]);
        refs.putIfAbsent((Object)sName, new AtomicReference<V>(initialValue));
        return new RemoteAtomicReference(refs, sName);
    }

    public static <V> LocalAtomicMarkableReference<V> localAtomicMarkableReference(String sName) {
        return Atomics.localAtomicMarkableReference(sName, null, false);
    }

    public static <V> LocalAtomicMarkableReference<V> localAtomicMarkableReference(String sName, V initialValue, boolean fInitialMark) {
        return LOCAL_MARKABLE_REFS.computeIfAbsent(sName, name -> new LocalAtomicMarkableReference<Object>(initialValue, fInitialMark));
    }

    public static <V> RemoteAtomicMarkableReference<V> remoteAtomicMarkableReference(String sName) {
        return Atomics.remoteAtomicMarkableReference(sName, null, false);
    }

    public static <V> RemoteAtomicMarkableReference<V> remoteAtomicMarkableReference(String sName, V initialValue, boolean fInitialMark) {
        NamedMap refs = Atomics.atomics().getMap("atomic-markable-ref", new NamedMap.Option[0]);
        refs.putIfAbsent((Object)sName, new SerializableAtomicMarkableReference<V>(initialValue, fInitialMark));
        return new RemoteAtomicMarkableReference(refs, sName);
    }

    public static <V> LocalAtomicStampedReference<V> localAtomicStampedReference(String sName) {
        return Atomics.localAtomicStampedReference(sName, null, 0);
    }

    public static <V> LocalAtomicStampedReference<V> localAtomicStampedReference(String sName, V initialValue, int nInitialStamp) {
        return LOCAL_STAMPED_REFS.computeIfAbsent(sName, name -> new LocalAtomicStampedReference<Object>(initialValue, nInitialStamp));
    }

    public static <V> RemoteAtomicStampedReference<V> remoteAtomicStampedReference(String sName) {
        return Atomics.remoteAtomicStampedReference(sName, null, 0);
    }

    public static <V> RemoteAtomicStampedReference<V> remoteAtomicStampedReference(String sName, V initialValue, int nInitialStamp) {
        NamedMap refs = Atomics.atomics().getMap("atomic-stamped-ref", new NamedMap.Option[0]);
        refs.putIfAbsent((Object)sName, new SerializableAtomicStampedReference<V>(initialValue, nInitialStamp));
        return new RemoteAtomicStampedReference(refs, sName);
    }

    static Session atomics() {
        return (Session)Coherence.findSession((String)SESSION_NAME).orElseThrow(() -> new IllegalStateException(String.format("The session '%s' has not been initialized", SESSION_NAME)));
    }

    static void reset() {
        LOCAL_BOOLEANS.clear();
        LOCAL_INTS.clear();
        LOCAL_LONGS.clear();
        LOCAL_REFS.clear();
        LOCAL_MARKABLE_REFS.clear();
        LOCAL_STAMPED_REFS.clear();
    }

    public static class SerializableAtomicMarkableReference<V>
    extends AtomicMarkableReference<V>
    implements ExternalizableLite {
        public SerializableAtomicMarkableReference() {
            super(null, false);
        }

        public SerializableAtomicMarkableReference(V initialRef, boolean initialMark) {
            super(initialRef, initialMark);
        }

        public void readExternal(DataInput in) throws IOException {
            this.set(ExternalizableHelper.readObject((DataInput)in), (Boolean)ExternalizableHelper.readObject((DataInput)in));
        }

        public void writeExternal(DataOutput out) throws IOException {
            boolean[] aMark = new boolean[1];
            ExternalizableHelper.writeObject((DataOutput)out, this.get(aMark));
            ExternalizableHelper.writeObject((DataOutput)out, (Object)aMark[0]);
        }
    }

    public static class SerializableAtomicStampedReference<V>
    extends AtomicStampedReference<V>
    implements ExternalizableLite {
        public SerializableAtomicStampedReference() {
            super(null, 0);
        }

        public SerializableAtomicStampedReference(V initialRef, int initialStamp) {
            super(initialRef, initialStamp);
        }

        public void readExternal(DataInput in) throws IOException {
            this.set(ExternalizableHelper.readObject((DataInput)in), (Integer)ExternalizableHelper.readObject((DataInput)in));
        }

        public void writeExternal(DataOutput out) throws IOException {
            int[] aiStamp = new int[1];
            ExternalizableHelper.writeObject((DataOutput)out, this.get(aiStamp));
            ExternalizableHelper.writeObject((DataOutput)out, (Object)aiStamp[0]);
        }
    }
}

