/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor.tasks;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.concurrent.executor.Task;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;

public class ValueTask<T>
implements Task<T>,
PortableObject {
    protected T m_value;
    protected long m_cInitialDelay;

    public ValueTask() {
    }

    public ValueTask(T value) {
        this(value, -1L);
    }

    public ValueTask(T value, long cInitialDelay) {
        this.m_value = value;
        this.m_cInitialDelay = cInitialDelay;
    }

    @Override
    public T execute(Task.Context<T> context) throws Exception {
        long cInitialDelay = this.m_cInitialDelay;
        if (cInitialDelay > 0L) {
            Blocking.sleep((long)cInitialDelay);
        }
        return this.m_value;
    }

    public void readExternal(DataInput in) throws IOException {
        this.m_value = ExternalizableHelper.readObject((DataInput)in);
        this.m_cInitialDelay = ExternalizableHelper.readLong((DataInput)in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject((DataOutput)out, this.m_value);
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.m_cInitialDelay);
    }

    public void readExternal(PofReader in) throws IOException {
        this.m_value = in.readObject(0);
        this.m_cInitialDelay = in.readLong(1);
    }

    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_value);
        out.writeLong(1, this.m_cInitialDelay);
    }

    public String toString() {
        return "ValueTask{value=" + String.valueOf(this.m_value) + ", initial-delay=" + this.m_cInitialDelay + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueTask valueTask = (ValueTask)o;
        return Objects.equals(this.m_value, valueTask.m_value) && this.m_cInitialDelay == valueTask.m_cInitialDelay;
    }

    public int hashCode() {
        return Objects.hash(this.m_value, this.m_cInitialDelay);
    }
}

