/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor.processors;

import com.oracle.coherence.concurrent.executor.PortableAbstractProcessor;
import com.oracle.coherence.concurrent.executor.Result;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.Member;
import com.tangosol.util.InvocableMap;
import java.io.IOException;

public class LocalOnlyProcessor<K, V, R>
extends PortableAbstractProcessor<K, V, R> {
    protected InvocableMap.EntryProcessor<K, V, R> m_processor;
    protected final Member f_submittingMember;

    public LocalOnlyProcessor() {
        this.f_submittingMember = CacheFactory.getCluster().getLocalMember();
    }

    public LocalOnlyProcessor(InvocableMap.EntryProcessor<K, V, R> processor) {
        this.m_processor = processor;
        this.f_submittingMember = CacheFactory.getCluster().getLocalMember();
    }

    public R process(InvocableMap.Entry<K, V> entry) {
        Member localMember = CacheFactory.getCluster().getLocalMember();
        if (localMember.equals((Object)this.f_submittingMember)) {
            return (R)Result.of(this.m_processor.process(entry));
        }
        return (R)Result.none();
    }

    public static <K, V, R> LocalOnlyProcessor<K, V, R> of(InvocableMap.EntryProcessor<K, V, R> processor) {
        return new LocalOnlyProcessor<K, V, R>(processor);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_processor = (InvocableMap.EntryProcessor)in.readObject(0);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_processor);
    }
}

