/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.locks;

import com.oracle.coherence.concurrent.locks.LockOwner;
import com.oracle.coherence.concurrent.locks.internal.ExclusiveLockHolder;
import com.tangosol.net.Member;
import com.tangosol.net.NamedMap;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.Processors;
import com.tangosol.util.listener.SimpleMapListener;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedLongSynchronizer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public class RemoteLock
implements Lock {
    private final Sync f_sync;

    RemoteLock(String sName, NamedMap<String, ExclusiveLockHolder> locks) {
        this.f_sync = new Sync(sName, locks);
        locks.addMapListener((MapListener)new SimpleMapListener().addInsertHandler(this.f_sync::onHolderChange).addUpdateHandler(this.f_sync::onHolderChange), (Object)sName, false);
    }

    @Override
    public void lock() {
        this.f_sync.acquire(1L);
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.f_sync.acquireInterruptibly(1L);
    }

    @Override
    public boolean tryLock() {
        return this.f_sync.tryAcquire(1L);
    }

    @Override
    public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
        return this.f_sync.tryAcquireNanos(1L, unit.toNanos(timeout));
    }

    @Override
    public void unlock() {
        this.f_sync.release(1L);
    }

    @Override
    public final Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    public long getHoldCount() {
        return this.f_sync.getHoldCount();
    }

    public boolean isHeldByCurrentThread() {
        return this.f_sync.isHeldExclusively();
    }

    public boolean isLocked() {
        return this.f_sync.isLocked();
    }

    public LockOwner getOwner() {
        return this.f_sync.getOwner();
    }

    public final boolean hasQueuedThreads() {
        return this.f_sync.hasQueuedThreads();
    }

    public final boolean hasQueuedThread(Thread thread) {
        return this.f_sync.isQueued(thread);
    }

    public final int getQueueLength() {
        return this.f_sync.getQueueLength();
    }

    public String toString() {
        LockOwner o = this.f_sync.getOwner();
        return super.toString() + (String)(o == null ? "[Unlocked]" : "[Locked by " + String.valueOf(o) + "]");
    }

    static class Sync
    extends AbstractQueuedLongSynchronizer {
        private final Member f_localMember;
        private final String f_sName;
        private final NamedMap<String, ExclusiveLockHolder> f_locks;

        Sync(String sName, NamedMap<String, ExclusiveLockHolder> locks) {
            Member localMember = locks.getService().getCluster().getLocalMember();
            this.f_sName = sName;
            this.f_locks = locks;
            this.f_localMember = localMember;
        }

        @Override
        protected final boolean tryAcquire(long acquires) {
            Thread thread = Thread.currentThread();
            if (acquires == -1L) {
                this.setState(-1L);
                this.setExclusiveOwnerThread(thread);
                return true;
            }
            long c = this.getState();
            if (c == 0L) {
                LockOwner owner = new LockOwner(this.f_localMember, thread.getId());
                boolean fLocked = (Boolean)this.f_locks.invoke((Object)this.f_sName, (InvocableMap.EntryProcessor & Serializable)entry -> {
                    ExclusiveLockHolder lock = (ExclusiveLockHolder)entry.getValue(ExclusiveLockHolder::new);
                    boolean fRes = lock.lock(owner);
                    entry.setValue((Object)lock);
                    return fRes;
                });
                if (fLocked && this.compareAndSetState(0L, acquires)) {
                    this.setExclusiveOwnerThread(thread);
                    return true;
                }
            } else if (thread == this.getExclusiveOwnerThread()) {
                long cNext = c + acquires;
                if (cNext < 0L) {
                    throw new Error("Maximum lock count exceeded");
                }
                this.setState(cNext);
                return true;
            }
            return false;
        }

        @Override
        protected final boolean tryRelease(long releases) {
            Thread thread = Thread.currentThread();
            if (releases == -1L) {
                if (thread == this.getExclusiveOwnerThread()) {
                    this.setState(0L);
                    this.setExclusiveOwnerThread(null);
                }
                return true;
            }
            long c = this.getState() - releases;
            if (thread != this.getExclusiveOwnerThread()) {
                throw new IllegalMonitorStateException(String.valueOf(thread) + " != " + String.valueOf(this.getExclusiveOwnerThread()));
            }
            boolean fFree = false;
            if (c == 0L) {
                LockOwner owner = new LockOwner(this.f_localMember, thread.getId());
                boolean fUnlocked = (Boolean)this.f_locks.invoke((Object)this.f_sName, (InvocableMap.EntryProcessor & Serializable)entry -> {
                    ExclusiveLockHolder lock = (ExclusiveLockHolder)entry.getValue();
                    if (lock != null && lock.unlock(owner)) {
                        entry.setValue((Object)lock);
                        return true;
                    }
                    return false;
                });
                if (fUnlocked) {
                    fFree = true;
                    this.setExclusiveOwnerThread(null);
                } else {
                    throw new IllegalMonitorStateException();
                }
            }
            this.setState(c);
            return fFree;
        }

        @Override
        protected final boolean isHeldExclusively() {
            return this.getExclusiveOwnerThread() == Thread.currentThread();
        }

        private void onHolderChange(MapEvent<? extends String, ? extends ExclusiveLockHolder> event) {
            ExclusiveLockHolder holder = (ExclusiveLockHolder)event.getNewValue();
            if (holder.isLocked() && !holder.isLockedByMember(this.f_localMember.getUuid())) {
                this.acquire(-1L);
            } else if (!holder.isLocked()) {
                this.release(-1L);
            }
        }

        final LockOwner getOwner() {
            return (LockOwner)this.f_locks.invoke((Object)this.f_sName, Processors.extract(ExclusiveLockHolder::getOwner));
        }

        final long getHoldCount() {
            return this.isHeldExclusively() ? this.getState() : 0L;
        }

        final boolean isLocked() {
            return (Boolean)this.f_locks.invoke((Object)this.f_sName, Processors.extract(ExclusiveLockHolder::isLocked));
        }
    }
}

