/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor;

import com.oracle.coherence.concurrent.config.ConcurrentServicesSessionConfiguration;
import com.oracle.coherence.concurrent.executor.ClusteredExecutorService;
import com.oracle.coherence.concurrent.executor.ClusteredOrchestration;
import com.oracle.coherence.concurrent.executor.Task;
import com.oracle.coherence.concurrent.executor.function.Predicates;
import com.oracle.coherence.concurrent.executor.options.Name;
import com.oracle.coherence.concurrent.executor.util.Caches;
import com.tangosol.net.CacheService;
import com.tangosol.net.Coherence;
import com.tangosol.net.NamedCache;
import com.tangosol.net.Session;
import com.tangosol.util.Extractors;
import com.tangosol.util.Filters;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.function.Remote;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;

public class NamedClusteredExecutorService
extends ClusteredExecutorService {
    protected final Name f_name;
    protected NamedCache m_viewNamed;

    public NamedClusteredExecutorService(Name name) {
        super(NamedClusteredExecutorService.session());
        this.f_name = name;
        this.m_viewNamed = Caches.executors(NamedClusteredExecutorService.session()).view().filter(Filters.equal((ValueExtractor)Extractors.extract((String)"getOption", (Object[])new Object[]{Name.class, null}), (Object)this.f_name)).build();
    }

    @Override
    public <T> Task.Orchestration<T> orchestrate(Task<T> task) {
        return new NamedOrchestration<T>(this, this.f_name, task);
    }

    @Override
    public void execute(Remote.Runnable command) {
        if (this.m_viewNamed.isEmpty()) {
            throw new RejectedExecutionException(String.format("No RemoteExecutor service available by name [%s]", this.f_name));
        }
        super.execute(command);
    }

    @Override
    public void shutdown() {
        this.release();
        super.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.release();
        return super.shutdownNow();
    }

    @Override
    protected void init(CacheService cacheService) {
        this.m_cacheService = cacheService;
    }

    public Name getName() {
        return this.f_name;
    }

    protected static Session session() {
        String sSessionName = ConcurrentServicesSessionConfiguration.SESSION_NAME;
        return (Session)Coherence.findSession((String)sSessionName).orElseThrow(() -> new IllegalStateException(String.format("The session '%s' has not been initialized", sSessionName)));
    }

    protected void release() {
        if (this.m_viewNamed != null) {
            this.m_viewNamed.release();
            this.m_viewNamed = null;
        }
    }

    protected static class NamedOrchestration<T>
    extends ClusteredOrchestration<T> {
        public NamedOrchestration(ClusteredExecutorService clusteredExecutorService, Name name, Task<T> task) {
            super(clusteredExecutorService, task);
            this.filter(Predicates.has(name));
        }
    }
}

