/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor.internal.cdi;

import com.oracle.coherence.cdi.Name;
import com.oracle.coherence.concurrent.executor.RemoteExecutor;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.Typed;
import jakarta.enterprise.inject.spi.DefinitionException;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.reflect.Member;

@ApplicationScoped
public class RemoteExecutorProducer {
    @Produces
    public RemoteExecutor getUnqualifiedRemoteExecutor(InjectionPoint injectionPoint) {
        return this.getRemoteExecutor(injectionPoint);
    }

    @Produces
    @Name(value="")
    @Typed(value={RemoteExecutor.class})
    public RemoteExecutor getRemoteExecutor(InjectionPoint injectionPoint) {
        return RemoteExecutor.get(this.getName(injectionPoint));
    }

    protected String getName(InjectionPoint injectionPoint) {
        String sName = injectionPoint.getQualifiers().stream().filter(a -> Name.class.equals(a.annotationType())).findFirst().map(a -> ((Name)a).value()).orElse(null);
        if (sName == null || sName.trim().isEmpty()) {
            Member member = injectionPoint.getMember();
            if (member == null) {
                String sMsg = "Cannot determine the name of the remote executor. No @Name qualifier and injection point member is null";
                throw new DefinitionException(sMsg);
            }
            sName = member.getName();
        }
        return sName;
    }
}

