/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor;

import com.oracle.coherence.concurrent.executor.ExecutionPlan;
import com.oracle.coherence.concurrent.executor.PortableAbstractProcessor;
import com.oracle.coherence.concurrent.executor.internal.ExecutorTrace;
import com.oracle.coherence.concurrent.executor.util.Caches;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.filter.AlwaysFilter;
import com.tangosol.util.filter.EqualsFilter;
import com.tangosol.util.processor.ConditionalRemove;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;

public class ClusteredAssignment
implements ExternalizableLite,
PortableObject {
    protected String m_sExecutorId;
    protected String m_sTaskId;
    protected State m_state;
    protected boolean m_fRecovered;

    public ClusteredAssignment() {
    }

    public ClusteredAssignment(String executorId, String sTaskId) {
        this.m_sExecutorId = executorId;
        this.m_sTaskId = sTaskId;
        this.m_state = State.ASSIGNED;
        this.m_fRecovered = false;
    }

    public void readExternal(DataInput in) throws IOException {
        this.m_sExecutorId = ExternalizableHelper.readSafeUTF((DataInput)in);
        this.m_sTaskId = ExternalizableHelper.readSafeUTF((DataInput)in);
        this.m_state = (State)((Object)ExternalizableHelper.readObject((DataInput)in));
        this.m_fRecovered = in.readBoolean();
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeUTF((DataOutput)out, (String)this.m_sExecutorId);
        ExternalizableHelper.writeUTF((DataOutput)out, (String)this.m_sTaskId);
        ExternalizableHelper.writeObject((DataOutput)out, (Object)((Object)this.m_state));
        out.writeBoolean(this.m_fRecovered);
    }

    public void readExternal(PofReader in) throws IOException {
        this.m_sExecutorId = in.readString(0);
        this.m_sTaskId = in.readString(1);
        this.m_state = (State)((Object)in.readObject(2));
        this.m_fRecovered = in.readBoolean(3);
    }

    public void writeExternal(PofWriter out) throws IOException {
        out.writeString(0, this.m_sExecutorId);
        out.writeString(1, this.m_sTaskId);
        out.writeObject(2, (Object)this.m_state);
        out.writeBoolean(3, this.m_fRecovered);
    }

    public String getExecutorId() {
        return this.m_sExecutorId;
    }

    public String getTaskId() {
        return this.m_sTaskId;
    }

    public State getState() {
        return this.m_state;
    }

    public void setState(State state) {
        this.m_state = state;
    }

    public boolean isRecovered() {
        return this.m_fRecovered;
    }

    public void setRecovered(boolean fRecovered) {
        this.m_fRecovered = fRecovered;
    }

    public String getCacheKey() {
        return ClusteredAssignment.getCacheKey(this.m_sExecutorId, this.m_sTaskId);
    }

    public String toString() {
        return "ClusteredAssignment{executorId='" + this.m_sExecutorId + "', taskId='" + this.m_sTaskId + "', state=" + this.m_state + ", recovered=" + this.m_fRecovered + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClusteredAssignment)) {
            return false;
        }
        ClusteredAssignment that = (ClusteredAssignment)o;
        if (this.m_fRecovered != that.m_fRecovered) {
            return false;
        }
        if (!this.m_sExecutorId.equals(that.m_sExecutorId)) {
            return false;
        }
        if (!this.m_sTaskId.equals(that.m_sTaskId)) {
            return false;
        }
        return this.m_state == that.m_state;
    }

    public int hashCode() {
        int result = this.m_sExecutorId.hashCode();
        result = 31 * result + this.m_sTaskId.hashCode();
        result = 31 * result + (this.m_state != null ? this.m_state.hashCode() : 0);
        result = 31 * result + (this.m_fRecovered ? 1 : 0);
        return result;
    }

    public static String getCacheKey(String sExecutorId, String sTaskId) {
        return sExecutorId + ":" + sTaskId;
    }

    public static void registerAssignments(String sTaskId, ExecutionPlan executionPlan, CacheService service) {
        NamedCache cacheAssignments = Caches.assignments(service);
        Iterator<String> iter = executionPlan.getIds();
        while (iter.hasNext()) {
            String executorId = iter.next();
            ClusteredAssignment assignment = new ClusteredAssignment(executorId, sTaskId);
            cacheAssignments.invoke((Object)assignment.getCacheKey(), (InvocableMap.EntryProcessor)new AssignmentProcessor(assignment, executionPlan.getAction(executorId)));
        }
    }

    public static void cancelAssignments(String sTaskId, CacheService service) {
        Caches.assignments(service).invokeAll((Filter)new EqualsFilter("getTaskId", (Object)sTaskId), (InvocableMap.EntryProcessor)new SetStateProcessor(State.EXECUTING, State.CANCELLED));
    }

    public static void removeAssignments(String sTaskId, CacheService service) {
        Caches.assignments(service).invokeAll((Filter)new EqualsFilter("getTaskId", (Object)sTaskId), (InvocableMap.EntryProcessor)new ConditionalRemove((Filter)AlwaysFilter.INSTANCE, false));
    }

    public static class SetStateProcessor
    extends PortableAbstractProcessor {
        protected State m_previous;
        protected State m_desired;

        public SetStateProcessor() {
        }

        public SetStateProcessor(State desired) {
            this.m_previous = null;
            this.m_desired = desired;
        }

        public SetStateProcessor(State previous, State desired) {
            this.m_previous = previous;
            this.m_desired = desired;
        }

        public Object process(InvocableMap.Entry entry) {
            if (entry.isPresent()) {
                ClusteredAssignment assignment = (ClusteredAssignment)entry.getValue();
                State existing = assignment.getState();
                if (existing != null && existing.equals((Object)this.m_previous) || this.m_previous == null) {
                    assignment.setState(this.m_desired);
                    entry.setValue((Object)assignment);
                    ExecutorTrace.log(() -> String.format("ClusteredAssignment State for Executor [%s] changed from [%s] to [%s]", new Object[]{entry.getKey(), this.m_previous, this.m_desired}));
                }
                return existing;
            }
            return null;
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_previous = (State)((Object)in.readObject(0));
            this.m_desired = (State)((Object)in.readObject(1));
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeObject(0, (Object)this.m_previous);
            out.writeObject(1, (Object)this.m_desired);
        }
    }

    public static class AssignmentProcessor
    extends PortableAbstractProcessor {
        protected ExecutionPlan.Action m_action;
        protected ClusteredAssignment m_assignment;

        public AssignmentProcessor() {
        }

        public AssignmentProcessor(ClusteredAssignment assignment, ExecutionPlan.Action action) {
            this.m_action = action;
            this.m_assignment = assignment;
        }

        public Object process(InvocableMap.Entry entry) {
            ExecutorTrace.log(() -> String.format("ClusteredAssignment State for Executor [%s] being configured because of [%s]", new Object[]{entry.getKey(), this.m_action}));
            switch (this.m_action) {
                case ASSIGN: 
                case RECOVER: {
                    ClusteredAssignment current = (ClusteredAssignment)entry.getValue();
                    if (entry.isPresent() && (!entry.isPresent() || current.equals(this.m_assignment))) break;
                    this.m_assignment.setState(State.ASSIGNED);
                    this.m_assignment.setRecovered(this.m_action == ExecutionPlan.Action.RECOVER);
                    entry.setValue((Object)this.m_assignment);
                    break;
                }
                case REASSIGN: 
                case RELEASE: {
                    if (!entry.isPresent()) break;
                    entry.remove(true);
                }
            }
            return null;
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_action = (ExecutionPlan.Action)((Object)in.readObject(0));
            this.m_assignment = (ClusteredAssignment)in.readObject(1);
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeObject(0, (Object)this.m_action);
            out.writeObject(1, (Object)this.m_assignment);
        }
    }

    public static enum State {
        ASSIGNED,
        EXECUTING,
        CANCELLED,
        EXECUTED;

    }
}

