/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor.atomic;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public final class AtomicEnum<T extends Enum<T>> {
    private final AtomicReference<T> f_reference;

    private AtomicEnum(T value) {
        this.f_reference = new AtomicReference<T>(value);
    }

    public boolean compareAndSet(T expect, T newValue) {
        return this.f_reference.compareAndSet(expect, newValue);
    }

    public T get() {
        return (T)((Enum)this.f_reference.get());
    }

    public T getAndSet(T newValue) {
        return (T)((Enum)this.f_reference.getAndSet(newValue));
    }

    public void set(T value) {
        this.f_reference.set(value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AtomicEnum)) {
            return false;
        }
        AtomicEnum that = (AtomicEnum)o;
        return Objects.equals(this.f_reference, that.f_reference);
    }

    public int hashCode() {
        return this.f_reference.hashCode();
    }

    public String toString() {
        return "AtomicEnum{" + ((Enum)this.f_reference.get()).toString() + "}";
    }

    public static <T extends Enum<T>> AtomicEnum<T> of(T value) {
        return new AtomicEnum<T>(value);
    }
}

