/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor.internal;

import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.concurrent.executor.ClusteredRegistration;
import com.oracle.coherence.concurrent.executor.options.Debugging;
import java.util.function.Supplier;

public class ExecutorTrace {
    public static final int LOGLEVEL = 7;

    public static boolean isEnabled() {
        return ClusteredRegistration.s_fTraceLogging;
    }

    public static void log(String message) {
        if (ExecutorTrace.isEnabled()) {
            Logger.log((String)message, (int)7);
        }
    }

    public static void log(String message, Debugging debugging) {
        if (ExecutorTrace.isEnabled()) {
            Logger.log((String)message, (int)debugging.getLogLevel());
        }
    }

    public static void log(Supplier<String> supplierMessage) {
        if (ExecutorTrace.isEnabled()) {
            Logger.log(supplierMessage, (int)7);
        }
    }

    public static void log(Supplier<String> supplierMessage, Debugging debugging) {
        if (ExecutorTrace.isEnabled()) {
            Logger.log(supplierMessage, (int)debugging.getLogLevel());
        }
    }

    public static void entering(Class<?> clz, String sMethod, Object ... params) {
        if (ExecutorTrace.isEnabled()) {
            Logger.entering(clz, (String)sMethod, (Object[])params);
        }
    }

    public static void entering(Class<?> clz, String sMethod, Supplier<Object> params) {
        if (ExecutorTrace.isEnabled()) {
            Logger.entering(clz, (String)sMethod, (Object[])new Object[]{params.get()});
        }
    }

    public static void exiting(Class<?> clz, String sMethod) {
        if (ExecutorTrace.isEnabled()) {
            Logger.exiting(clz, (String)sMethod);
        }
    }

    public static void exiting(Class<?> clz, String sMethod, Object result, Object ... additionalInfo) {
        if (ExecutorTrace.isEnabled()) {
            Logger.exiting(clz, (String)sMethod, (Object)result, (Object[])additionalInfo);
        }
    }

    public static void exiting(Class<?> clz, String sMethod, Object result, Supplier<Object> params) {
        if (ExecutorTrace.isEnabled()) {
            Logger.exiting(clz, (String)sMethod, (Object)result, (Object[])new Object[]{params.get()});
        }
    }

    public static void throwing(Class<?> clz, String sMethod, Throwable throwable, Object ... additionalInfo) {
        if (ExecutorTrace.isEnabled()) {
            Logger.throwing(clz, (String)sMethod, (Throwable)throwable, (Object[])additionalInfo);
        }
    }
}

