/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.atomic;

import com.oracle.coherence.concurrent.atomic.AsyncAtomicLong;
import com.tangosol.util.function.Remote;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongBinaryOperator;
import java.util.function.LongUnaryOperator;

public class AsyncLocalAtomicLong
implements AsyncAtomicLong {
    private final AtomicLong f_lValue;

    protected AsyncLocalAtomicLong(AtomicLong value) {
        this.f_lValue = value;
    }

    @Override
    public CompletableFuture<Long> get() {
        return CompletableFuture.completedFuture(this.f_lValue.get());
    }

    @Override
    public CompletableFuture<Void> set(long lNewValue) {
        this.f_lValue.set(lNewValue);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Long> getAndSet(long lNewValue) {
        return CompletableFuture.completedFuture(this.f_lValue.getAndSet(lNewValue));
    }

    @Override
    public CompletableFuture<Boolean> compareAndSet(long lExpectedValue, long lNewValue) {
        return CompletableFuture.completedFuture(this.f_lValue.compareAndSet(lExpectedValue, lNewValue));
    }

    @Override
    public CompletableFuture<Long> getAndIncrement() {
        return this.getAndAdd(1L);
    }

    @Override
    public CompletableFuture<Long> getAndDecrement() {
        return this.getAndAdd(-1L);
    }

    @Override
    public CompletableFuture<Long> getAndAdd(long lDelta) {
        return CompletableFuture.completedFuture(this.f_lValue.getAndAdd(lDelta));
    }

    @Override
    public CompletableFuture<Long> incrementAndGet() {
        return this.addAndGet(1L);
    }

    @Override
    public CompletableFuture<Long> decrementAndGet() {
        return this.addAndGet(-1L);
    }

    @Override
    public CompletableFuture<Long> addAndGet(long lDelta) {
        return CompletableFuture.completedFuture(this.f_lValue.addAndGet(lDelta));
    }

    @Override
    public CompletableFuture<Long> getAndUpdate(Remote.LongUnaryOperator updateFunction) {
        return this.getAndUpdate((LongUnaryOperator)updateFunction);
    }

    @Override
    public CompletableFuture<Long> getAndUpdate(LongUnaryOperator updateFunction) {
        return CompletableFuture.completedFuture(this.f_lValue.getAndUpdate(updateFunction));
    }

    @Override
    public CompletableFuture<Long> updateAndGet(Remote.LongUnaryOperator updateFunction) {
        return this.updateAndGet((LongUnaryOperator)updateFunction);
    }

    @Override
    public CompletableFuture<Long> updateAndGet(LongUnaryOperator updateFunction) {
        return CompletableFuture.completedFuture(this.f_lValue.updateAndGet(updateFunction));
    }

    @Override
    public CompletableFuture<Long> getAndAccumulate(long lUpdate, Remote.LongBinaryOperator accumulatorFunction) {
        return this.getAndAccumulate(lUpdate, (LongBinaryOperator)accumulatorFunction);
    }

    @Override
    public CompletableFuture<Long> getAndAccumulate(long lUpdate, LongBinaryOperator accumulatorFunction) {
        return CompletableFuture.completedFuture(this.f_lValue.getAndAccumulate(lUpdate, accumulatorFunction));
    }

    @Override
    public CompletableFuture<Long> accumulateAndGet(long lUpdate, Remote.LongBinaryOperator accumulatorFunction) {
        return this.accumulateAndGet(lUpdate, (LongBinaryOperator)accumulatorFunction);
    }

    @Override
    public CompletableFuture<Long> accumulateAndGet(long lUpdate, LongBinaryOperator accumulatorFunction) {
        return CompletableFuture.completedFuture(this.f_lValue.accumulateAndGet(lUpdate, accumulatorFunction));
    }

    @Override
    public CompletableFuture<Long> compareAndExchange(long lExpectedValue, long lNewValue) {
        return CompletableFuture.completedFuture(this.f_lValue.compareAndExchange(lExpectedValue, lNewValue));
    }

    @Override
    public CompletableFuture<Integer> intValue() {
        return CompletableFuture.completedFuture(this.f_lValue.intValue());
    }

    @Override
    public CompletableFuture<Long> longValue() {
        return CompletableFuture.completedFuture(this.f_lValue.longValue());
    }

    @Override
    public CompletableFuture<Float> floatValue() {
        return CompletableFuture.completedFuture(Float.valueOf(this.f_lValue.floatValue()));
    }

    @Override
    public CompletableFuture<Double> doubleValue() {
        return CompletableFuture.completedFuture(this.f_lValue.doubleValue());
    }

    @Override
    public CompletableFuture<Byte> byteValue() {
        return CompletableFuture.completedFuture(this.f_lValue.byteValue());
    }

    @Override
    public CompletableFuture<Short> shortValue() {
        return CompletableFuture.completedFuture(this.f_lValue.shortValue());
    }

    public String toString() {
        return Long.toString(this.get().join());
    }
}

