/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.locks.internal.cdi;

import com.oracle.coherence.cdi.Name;
import com.oracle.coherence.cdi.Remote;
import com.oracle.coherence.concurrent.locks.Locks;
import com.oracle.coherence.concurrent.locks.RemoteReadWriteLock;
import com.oracle.coherence.concurrent.locks.internal.cdi.AbstractLockProducer;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.InjectionPoint;

@ApplicationScoped
public class ReadWriteLockProducer
extends AbstractLockProducer {
    @Produces
    @Name(value="")
    @Remote
    ReadWriteLock getReadWriteLock(InjectionPoint ip) {
        if (ip.getQualifiers().contains(Remote.Literal.INSTANCE)) {
            return this.getRemoteReadWriteLock(ip);
        }
        return this.getReentrantReadWriteLock(ip);
    }

    @Produces
    ReentrantReadWriteLock getUnqualifiedReentrantReadWriteLock(InjectionPoint ip) {
        return this.getReentrantReadWriteLock(ip);
    }

    @Produces
    @Name(value="")
    @Typed(value={ReentrantReadWriteLock.class})
    ReentrantReadWriteLock getReentrantReadWriteLock(InjectionPoint ip) {
        return Locks.localReadWriteLock(this.getName(ip));
    }

    @Produces
    @Typed(value={RemoteReadWriteLock.class})
    RemoteReadWriteLock getUnqualifiedRemoteReadWriteLock(InjectionPoint ip) {
        return this.getRemoteReadWriteLock(ip);
    }

    @Produces
    @Name(value="")
    @Typed(value={RemoteReadWriteLock.class})
    RemoteReadWriteLock getRemoteReadWriteLock(InjectionPoint ip) {
        return Locks.remoteReadWriteLock(this.getName(ip));
    }
}

