/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.internal;

import com.oracle.coherence.concurrent.Semaphores;
import com.oracle.coherence.concurrent.internal.SemaphoreStatus;
import com.oracle.coherence.concurrent.locks.Locks;
import com.oracle.coherence.concurrent.locks.internal.ExclusiveLockHolder;
import com.oracle.coherence.concurrent.locks.internal.ReadWriteLockHolder;
import com.tangosol.net.AsyncNamedMap;
import com.tangosol.net.CacheService;
import com.tangosol.net.DistributedCacheService;
import com.tangosol.net.Member;
import com.tangosol.net.MemberEvent;
import com.tangosol.net.MemberListener;
import com.tangosol.net.PartitionedService;
import com.tangosol.net.events.EventDispatcher;
import com.tangosol.net.events.EventDispatcherAwareInterceptor;
import com.tangosol.net.events.EventInterceptor;
import com.tangosol.net.events.partition.PartitionedServiceDispatcher;
import com.tangosol.net.events.partition.TransferEvent;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.filter.AlwaysFilter;
import com.tangosol.util.filter.PartitionedFilter;
import java.util.Collections;
import java.util.Set;

public class Cleaner
implements MemberListener,
EventDispatcherAwareInterceptor<TransferEvent> {
    protected volatile String m_sServiceName;
    protected volatile PartitionSet m_partsCheck;

    public void onEvent(TransferEvent event) {
        if (event.getType() == TransferEvent.Type.ARRIVED) {
            PartitionedService service = event.getDispatcher().getService();
            this.enqueueUpdate(event.getPartitionId(), service.getPartitionCount());
        }
    }

    public void introduceEventDispatcher(String sIdentifier, EventDispatcher dispatcher) {
        String sServiceName;
        if (dispatcher instanceof PartitionedServiceDispatcher && (sServiceName = ((PartitionedServiceDispatcher)dispatcher).getService().getInfo().getServiceName()).equals(this.m_sServiceName)) {
            Set<TransferEvent.Type> setTypes = Collections.singletonMap(TransferEvent.Type.ARRIVED, null).keySet();
            dispatcher.addEventInterceptor(null, (EventInterceptor)this, setTypes, false);
        }
    }

    public void memberJoined(MemberEvent evt) {
        PartitionedService service = (PartitionedService)evt.getService();
        if (evt.isLocal() && ((DistributedCacheService)service).isLocalStorageEnabled()) {
            this.m_sServiceName = service.getInfo().getServiceName();
            ((CacheService)service).getBackingMapManager().getCacheFactory().getInterceptorRegistry().registerEventInterceptor((EventInterceptor)this);
        }
    }

    public void memberLeaving(MemberEvent evt) {
    }

    public void memberLeft(MemberEvent evt) {
        PartitionedService service = (PartitionedService)evt.getService();
        Member memberThis = service.getCluster().getLocalMember();
        Member memberLeft = evt.getMember();
        Runnable runnable = () -> {
            if (service.isRunning() && ((DistributedCacheService)service).isLocalStorageEnabled()) {
                PartitionSet partsOwned = service.getOwnedPartitions(memberThis);
                Locks.exclusiveLocksMap().async(new AsyncNamedMap.Option[0]).invokeAll((Filter)new PartitionedFilter((Filter)AlwaysFilter.INSTANCE(), partsOwned), (InvocableMap.EntryProcessor)new ExclusiveLockHolder.RemoveLocks(memberLeft.getUuid()));
                Locks.readWriteLocksMap().async(new AsyncNamedMap.Option[0]).invokeAll((Filter)new PartitionedFilter((Filter)AlwaysFilter.INSTANCE(), partsOwned), (InvocableMap.EntryProcessor)new ReadWriteLockHolder.RemoveLocks(memberLeft.getUuid()));
                Semaphores.semaphoresMap().async(new AsyncNamedMap.Option[0]).invokeAll((Filter)new PartitionedFilter((Filter)AlwaysFilter.INSTANCE(), partsOwned), (InvocableMap.EntryProcessor)new SemaphoreStatus.RemovePermits(memberLeft.getUuid()));
            }
        };
        Base.makeThread(null, (Runnable)runnable, (String)"ConcurrentLockCleaner").start();
    }

    protected synchronized void enqueueUpdate(int iPartition, int cParts) {
        PartitionSet parts = this.m_partsCheck;
        if (parts == null) {
            parts = this.m_partsCheck = new PartitionSet(cParts);
            Base.makeThread(null, (Runnable)new CheckHoldersRunnable(), (String)"CheckLockHolders").start();
        }
        parts.add(iPartition);
    }

    protected class CheckHoldersRunnable
    implements Runnable {
        protected CheckHoldersRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PartitionSet parts;
            Base.sleep((long)1000L);
            Cleaner cleaner = Cleaner.this;
            synchronized (cleaner) {
                parts = Cleaner.this.m_partsCheck;
                Cleaner.this.m_partsCheck = null;
            }
            Locks.exclusiveLocksMap().async(new AsyncNamedMap.Option[0]).invokeAll((Filter)new PartitionedFilter((Filter)AlwaysFilter.INSTANCE(), parts), (InvocableMap.EntryProcessor)new ExclusiveLockHolder.RemoveLocks(null));
            Locks.readWriteLocksMap().async(new AsyncNamedMap.Option[0]).invokeAll((Filter)new PartitionedFilter((Filter)AlwaysFilter.INSTANCE(), parts), (InvocableMap.EntryProcessor)new ReadWriteLockHolder.RemoveLocks(null));
            Semaphores.semaphoresMap().async(new AsyncNamedMap.Option[0]).invokeAll((Filter)new PartitionedFilter((Filter)AlwaysFilter.INSTANCE(), parts), (InvocableMap.EntryProcessor)new SemaphoreStatus.RemovePermits(null));
        }
    }
}

