/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor;

import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.concurrent.executor.AbstractTaskCoordinator;
import com.oracle.coherence.concurrent.executor.ClusteredProperties;
import com.oracle.coherence.concurrent.executor.ClusteredTaskManager;
import com.oracle.coherence.concurrent.executor.Result;
import com.oracle.coherence.concurrent.executor.Task;
import com.oracle.coherence.concurrent.executor.internal.ExecutorTrace;
import com.tangosol.net.CacheService;
import com.tangosol.net.MemberEvent;
import com.tangosol.net.MemberListener;
import com.tangosol.net.NamedCache;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.filter.NotFilter;
import com.tangosol.util.filter.PresentFilter;
import com.tangosol.util.processor.ConditionalPut;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;

public class ClusteredTaskCoordinator<T>
extends AbstractTaskCoordinator<T>
implements MapListener {
    protected NamedCache m_taskManagers;
    protected Task.Properties m_properties;
    protected final ClusteredMemberListener f_memberListener;

    public ClusteredTaskCoordinator(CacheService service, ClusteredTaskManager manager, ExecutorService executorService) {
        super(manager.getTaskId(), executorService, manager.getRetainDuration() != null);
        this.m_taskManagers = service.ensureCache(ClusteredTaskManager.CACHE_NAME, null);
        this.m_taskManagers.addMapListener((MapListener)this, (Object)this.getTaskId(), false);
        this.f_memberListener = new ClusteredMemberListener(this, service);
        this.addMemberListener(this.f_memberListener);
    }

    public ClusteredTaskCoordinator(CacheService service, ClusteredTaskManager manager, ExecutorService executorService, Task.Properties properties, Iterator<Task.Subscriber<? super T>> subscribers) {
        super(manager.getTaskId(), executorService, manager.getRetainDuration() != null);
        this.m_taskManagers = service.ensureCache(ClusteredTaskManager.CACHE_NAME, null);
        this.m_properties = properties;
        if (subscribers != null) {
            while (subscribers.hasNext()) {
                Task.Subscriber<? super T> subscriber = subscribers.next();
                this.subscribe(subscriber);
            }
        }
        this.m_taskManagers.addMapListener((MapListener)this, (Object)this.getTaskId(), false);
        this.f_memberListener = new ClusteredMemberListener(this, service);
        this.addMemberListener(this.f_memberListener);
        ClusteredTaskManager existing = (ClusteredTaskManager)this.m_taskManagers.invoke((Object)this.f_sTaskId, (InvocableMap.EntryProcessor)new ConditionalPut((Filter)new NotFilter((Filter)new PresentFilter()), (Object)manager, true));
        if (existing != null) {
            this.m_taskManagers.removeMapListener((MapListener)this, (Object)this.getTaskId());
            Logger.warn(() -> String.format("Task with the identity [%s] already exists.  Task will not be created.", this.f_sTaskId));
            throw new IllegalArgumentException("Task with identity [" + this.f_sTaskId + "] already exists");
        }
    }

    @Override
    public boolean cancel(boolean fMayInterruptIfRunning) {
        return (Boolean)this.m_taskManagers.invoke((Object)this.getTaskId(), (InvocableMap.EntryProcessor)new ClusteredTaskManager.TerminateProcessor(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task.Properties getProperties() {
        ClusteredTaskCoordinator clusteredTaskCoordinator = this;
        synchronized (clusteredTaskCoordinator) {
            if (this.m_properties == null) {
                this.m_properties = new ClusteredProperties(this.f_sTaskId, this.m_taskManagers.getCacheService());
            }
        }
        return this.m_properties;
    }

    @Override
    protected void subscribeRetainedTask(Task.Subscriber subscriber) {
        ClusteredTaskManager taskManager = (ClusteredTaskManager)this.m_taskManagers.get((Object)this.f_sTaskId);
        if (taskManager != null) {
            try {
                Object result = taskManager.getLastResult().get();
                subscriber.onNext(result);
            }
            catch (Throwable t) {
                subscriber.onError(t);
            }
        } else {
            throw new IllegalStateException("Task : [" + this.f_sTaskId + "] not found.");
        }
        subscriber.onComplete();
    }

    @Override
    public void close() {
        super.close();
        this.removeMemberListener(this.f_memberListener);
    }

    public void entryInserted(MapEvent mapEvent) {
    }

    public void entryUpdated(MapEvent mapEvent) {
        ClusteredTaskManager oldManager = (ClusteredTaskManager)mapEvent.getOldValue();
        ClusteredTaskManager manager = (ClusteredTaskManager)mapEvent.getNewValue();
        int latestResultVersion = manager.getResultVersion();
        if (oldManager.getResultVersion() != latestResultVersion) {
            Result lastResult = this.m_lastValue = manager.getLastResult();
            ExecutorTrace.log(() -> String.format("Task [%s] has a new result[%s]: [%s]", this.getTaskId(), latestResultVersion, lastResult));
            this.offer(lastResult);
        }
        if (manager.isCancelled() || manager.isCompleted()) {
            if (manager.isCancelled()) {
                ExecutorTrace.log(() -> String.format("Task [%s] has been cancelled.", this.getTaskId()));
                super.cancel(true);
            } else {
                ExecutorTrace.log(() -> String.format("Task [%s] has been completed.", this.getTaskId()));
                this.close();
            }
            if (manager.getRunCompletionRunnable()) {
                try {
                    manager.getCompletionRunnable().accept(manager.getLastResult().get());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                manager.setRunCompletionRunnable(false);
            }
            this.removeMapListener();
        }
    }

    public void entryDeleted(MapEvent mapEvent) {
        ExecutorTrace.log(() -> String.format("Task [%s] has been removed.", this.getTaskId()));
        this.removeMapListener();
    }

    public void addMemberListener(MemberListener listener) {
        if (this.m_taskManagers != null) {
            this.m_taskManagers.getCacheService().addMemberListener(listener);
        }
    }

    public void removeMemberListener(MemberListener listener) {
        if (this.m_taskManagers != null) {
            this.m_taskManagers.getCacheService().removeMemberListener(listener);
        }
    }

    protected void removeMapListener() {
        ClusteredTaskCoordinator coordinator = this;
        Runnable removeMapListenerRunnable = () -> this.m_taskManagers.removeMapListener((MapListener)coordinator, (Object)this.getTaskId());
        try {
            this.f_executorService.submit(removeMapListenerRunnable);
        }
        catch (RejectedExecutionException e) {
            Logger.fine(() -> String.format("MapListener for Task [%s] could not be removed asynchronously.", this.getTaskId()));
        }
    }

    public class ClusteredMemberListener
    implements MemberListener {
        protected final ClusteredTaskCoordinator f_coordinator;
        protected final CacheService f_service;

        ClusteredMemberListener(ClusteredTaskCoordinator coordinator, CacheService service) {
            this.f_coordinator = coordinator;
            this.f_service = service;
        }

        public void memberLeaving(MemberEvent event) {
        }

        public void memberLeft(MemberEvent event) {
        }

        public void memberJoined(MemberEvent event) {
            Runnable addMapListenerRunnable = () -> {
                ClusteredTaskCoordinator.this.m_taskManagers = this.f_service.ensureCache(ClusteredTaskManager.CACHE_NAME, null);
                ClusteredTaskCoordinator.this.m_taskManagers.get((Object)ClusteredTaskCoordinator.this.getTaskId());
                ClusteredTaskCoordinator.this.m_taskManagers.addMapListener((MapListener)this.f_coordinator, (Object)ClusteredTaskCoordinator.this.getTaskId(), false);
            };
            try {
                ClusteredTaskCoordinator.this.f_executorService.submit(addMapListenerRunnable);
            }
            catch (RejectedExecutionException e) {
                Logger.fine(() -> String.format("MapListener for Task [%s] could not be added asynchronously.", ClusteredTaskCoordinator.this.getTaskId()));
            }
        }
    }
}

