/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.locks;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.UID;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;

public class LockOwner
implements ExternalizableLite,
PortableObject {
    private UID m_memberId;
    private long m_threadId;

    public LockOwner() {
    }

    public LockOwner(UID memberId, long threadId) {
        this.m_memberId = memberId;
        this.m_threadId = threadId;
    }

    public UID getMemberId() {
        return this.m_memberId;
    }

    public long getThreadId() {
        return this.m_threadId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LockOwner lockOwner = (LockOwner)o;
        return this.m_threadId == lockOwner.m_threadId && this.m_memberId.equals((Object)lockOwner.m_memberId);
    }

    public int hashCode() {
        return Objects.hash(this.m_memberId, this.m_threadId);
    }

    public String toString() {
        return "LockOwner{memberId=" + this.m_memberId + ", threadId=" + this.m_threadId + "}";
    }

    public void readExternal(DataInput in) throws IOException {
        this.m_memberId = (UID)ExternalizableHelper.readObject((DataInput)in);
        this.m_threadId = in.readLong();
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.m_memberId);
        out.writeLong(this.m_threadId);
    }

    public void readExternal(PofReader in) throws IOException {
        this.m_memberId = (UID)in.readObject(1);
        this.m_threadId = in.readLong(2);
    }

    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(1, (Object)this.m_memberId);
        out.writeLong(2, this.m_threadId);
    }
}

