/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor;

import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.concurrent.executor.ClusteredAssignment;
import com.oracle.coherence.concurrent.executor.ClusteredRegistration;
import com.oracle.coherence.concurrent.executor.ClusteredTaskManager;
import com.oracle.coherence.concurrent.executor.ComposableContinuation;
import com.oracle.coherence.concurrent.executor.PortableAbstractProcessor;
import com.oracle.coherence.concurrent.executor.TaskExecutorService;
import com.oracle.coherence.concurrent.executor.internal.Cause;
import com.oracle.coherence.concurrent.executor.internal.ClusterMemberAware;
import com.oracle.coherence.concurrent.executor.internal.ExecutorTrace;
import com.oracle.coherence.concurrent.executor.internal.Leased;
import com.oracle.coherence.concurrent.executor.internal.LiveObject;
import com.oracle.coherence.concurrent.executor.options.ClusterMember;
import com.oracle.coherence.concurrent.executor.options.Member;
import com.oracle.coherence.concurrent.executor.options.Name;
import com.oracle.coherence.concurrent.executor.util.OptionsByType;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.UID;
import com.tangosol.util.filter.AlwaysFilter;
import com.tangosol.util.filter.EqualsFilter;
import com.tangosol.util.processor.ConditionalRemove;
import com.tangosol.util.processor.ExtractorProcessor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

public class ClusteredExecutorInfo
implements TaskExecutorService.ExecutorInfo,
LiveObject,
Leased,
ClusterMemberAware,
PortableObject {
    public static final String CACHE_NAME = "executor-executors";
    public static long LEASE_DURATION_MS = 30000L;
    protected TaskExecutorService.ExecutorInfo.State m_state = TaskExecutorService.ExecutorInfo.State.JOINING;
    protected String m_sIdentity;
    protected OptionsByType<TaskExecutorService.Registration.Option> m_optionsByType;
    protected long m_ldtUpdate;
    protected long m_cMaxMemory;
    protected long m_cTotalMemory;
    protected long m_cFreeMemory;
    protected long m_cCompleted;
    protected long m_cRejected;
    protected long m_cInProgress;

    public ClusteredExecutorInfo() {
    }

    public ClusteredExecutorInfo(String sIdentity, long ldtUpdate, long cMaxMemory, long totalMemory, long freeMemory, OptionsByType<TaskExecutorService.Registration.Option> optionsByType) {
        this.m_sIdentity = sIdentity;
        this.m_optionsByType = optionsByType;
        this.m_ldtUpdate = ldtUpdate;
        this.m_cMaxMemory = cMaxMemory;
        this.m_cTotalMemory = totalMemory;
        this.m_cFreeMemory = freeMemory;
        this.m_cCompleted = 0L;
        this.m_cRejected = 0L;
        this.m_cInProgress = 0L;
    }

    public void touch() {
        this.m_ldtUpdate = CacheFactory.getSafeTimeMillis();
    }

    @Override
    public String getId() {
        return this.m_sIdentity;
    }

    @Override
    public TaskExecutorService.ExecutorInfo.State getState() {
        return this.m_state;
    }

    @Override
    public long getLastUpdateTime() {
        return this.m_ldtUpdate;
    }

    @Override
    public long getMaxMemory() {
        return this.m_cMaxMemory;
    }

    @Override
    public long getTotalMemory() {
        return this.m_cTotalMemory;
    }

    @Override
    public long getFreeMemory() {
        return this.m_cFreeMemory;
    }

    @Override
    public <T extends TaskExecutorService.Registration.Option> T getOption(Class<T> clzOfOption, T defaultIfNotFound) {
        return (T)((TaskExecutorService.Registration.Option)this.m_optionsByType.get(clzOfOption, defaultIfNotFound));
    }

    public void setState(TaskExecutorService.ExecutorInfo.State state) {
        ExecutorTrace.log(() -> String.format("ClusteredExecutorInfo [%s] changing state from [%s] to [%s]", new Object[]{this.m_sIdentity, this.m_state, state}));
        this.m_state = state;
    }

    public long getTasksCompletedCount() {
        return this.m_cCompleted;
    }

    public long getTasksRejectedCount() {
        return this.m_cRejected;
    }

    public long getTasksInProgressCount() {
        return this.m_cInProgress;
    }

    public void setMaxMemory(long cMaxMemory) {
        this.m_cMaxMemory = cMaxMemory;
    }

    public void setTotalMemory(long cTotalMemory) {
        this.m_cTotalMemory = cTotalMemory;
    }

    public void setFreeMemory(long cFreeMemory) {
        this.m_cFreeMemory = cFreeMemory;
    }

    public void setTasksCompletedCount(long cTasksCompleted) {
        this.m_cCompleted = cTasksCompleted;
    }

    public void setTasksFailedCount(long cTasksFailed) {
        this.m_cRejected = cTasksFailed;
    }

    public void setTasksInProgressCount(long cTasksInProgress) {
        this.m_cInProgress = cTasksInProgress;
    }

    public String getExecutorName() {
        return this.getOption(Name.class, Name.UNNAMED).getName();
    }

    public String toString() {
        return "ClusteredExecutorInfo{identity='" + this.m_sIdentity + "', state=" + this.m_state + ", lastUpdateTime=" + this.m_ldtUpdate + ", maxMemory=" + this.m_cMaxMemory + ", totalMemory=" + this.m_cTotalMemory + ", freeMemory=" + this.m_cFreeMemory + ", optionsByType=" + this.m_optionsByType + ", completed=" + this.m_cCompleted + ", in-progress=" + this.m_cInProgress + ", rejected=" + this.m_cRejected + "}";
    }

    @Override
    public long getLeaseExpiryTime() {
        return this.m_ldtUpdate + LEASE_DURATION_MS;
    }

    @Override
    public void renew() {
        this.touch();
    }

    @Override
    public boolean onLeaseExpiry() {
        ExecutorTrace.log(() -> String.format("Lease for Executor [%s] in [%s] has expired", new Object[]{this.m_sIdentity, this.m_state}));
        if (this.m_state != TaskExecutorService.ExecutorInfo.State.CLOSED && this.m_state != TaskExecutorService.ExecutorInfo.State.CLOSING) {
            this.setState(TaskExecutorService.ExecutorInfo.State.CLOSING);
            return true;
        }
        return false;
    }

    @Override
    public ComposableContinuation onInserted(CacheService service, InvocableMap.Entry entry, Cause cause) {
        ExecutorTrace.log(() -> String.format("Inserted [%s] due to [%s]", new Object[]{this, cause}));
        switch (this.m_state) {
            case JOINING: {
                return new JoiningContinuation(this.m_sIdentity, service);
            }
            case RUNNING: {
                return null;
            }
            case CLOSING_GRACEFULLY: {
                return new ClosingGracefullyContinuation(this.m_sIdentity, service);
            }
            case CLOSING: {
                return new ClosingContinuation(this.m_sIdentity, service);
            }
            case CLOSED: {
                return new RemoveContinuation(this.m_sIdentity, service);
            }
        }
        return null;
    }

    @Override
    public ComposableContinuation onUpdated(CacheService service, InvocableMap.Entry entry, Cause cause) {
        ExecutorTrace.log(() -> String.format("Updated [%s] due to [%s]", new Object[]{this, cause}));
        switch (this.m_state) {
            case JOINING: {
                return null;
            }
            case RUNNING: {
                return null;
            }
            case CLOSING_GRACEFULLY: {
                return new ClosingGracefullyContinuation(this.m_sIdentity, service);
            }
            case CLOSING: {
                return new ClosingContinuation(this.m_sIdentity, service);
            }
            case CLOSED: {
                return new RemoveContinuation(this.m_sIdentity, service);
            }
        }
        return null;
    }

    @Override
    public ComposableContinuation onDeleted(CacheService service, InvocableMap.Entry entry, Cause cause) {
        ExecutorTrace.log(() -> String.format("Deleted [%s] due to [%s]", new Object[]{this, cause}));
        String sExecutorId = (String)entry.getKey();
        service.getResourceRegistry().unregisterResource(ClusteredExecutorInfo.class, sExecutorId);
        return null;
    }

    @Override
    public UID getUid() {
        return this.m_optionsByType.get(ClusterMember.class) == null ? null : this.m_optionsByType.get(Member.class, Member.autoDetect()).get().getUid();
    }

    @Override
    public boolean onMemberJoined() {
        Logger.fine(() -> String.format("Executor [%s] in [%s] has joined the cluster", new Object[]{this.m_sIdentity, this.m_state}));
        return false;
    }

    @Override
    public boolean onMemberLeaving() {
        return false;
    }

    @Override
    public boolean onMemberLeft() {
        Logger.fine(() -> String.format("Executor [%s] in [%s] has left the cluster", new Object[]{this.m_sIdentity, this.m_state}));
        if (this.m_state != TaskExecutorService.ExecutorInfo.State.CLOSED && this.m_state != TaskExecutorService.ExecutorInfo.State.CLOSING) {
            this.setState(TaskExecutorService.ExecutorInfo.State.CLOSING);
            return true;
        }
        return false;
    }

    public void readExternal(DataInput in) throws IOException {
        this.m_state = (TaskExecutorService.ExecutorInfo.State)((Object)ExternalizableHelper.readObject((DataInput)in));
        this.m_sIdentity = ExternalizableHelper.readUTF((DataInput)in);
        this.m_optionsByType = (OptionsByType)ExternalizableHelper.readObject((DataInput)in);
        this.m_ldtUpdate = ExternalizableHelper.readLong((DataInput)in);
        this.m_cMaxMemory = ExternalizableHelper.readLong((DataInput)in);
        this.m_cTotalMemory = ExternalizableHelper.readLong((DataInput)in);
        this.m_cFreeMemory = ExternalizableHelper.readLong((DataInput)in);
        this.m_cCompleted = ExternalizableHelper.readLong((DataInput)in);
        this.m_cRejected = ExternalizableHelper.readLong((DataInput)in);
        this.m_cInProgress = ExternalizableHelper.readLong((DataInput)in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject((DataOutput)out, (Object)((Object)this.m_state));
        ExternalizableHelper.writeUTF((DataOutput)out, (String)this.m_sIdentity);
        ExternalizableHelper.writeObject((DataOutput)out, this.m_optionsByType);
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.m_ldtUpdate);
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.m_cMaxMemory);
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.m_cTotalMemory);
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.m_cFreeMemory);
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.m_cCompleted);
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.m_cRejected);
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.m_cInProgress);
    }

    public void readExternal(PofReader in) throws IOException {
        this.m_state = (TaskExecutorService.ExecutorInfo.State)((Object)in.readObject(0));
        this.m_sIdentity = in.readString(1);
        this.m_optionsByType = (OptionsByType)in.readObject(2);
        this.m_ldtUpdate = in.readLong(3);
        this.m_cMaxMemory = in.readLong(4);
        this.m_cTotalMemory = in.readLong(5);
        this.m_cFreeMemory = in.readLong(6);
        this.m_cCompleted = in.readLong(7);
        this.m_cRejected = in.readLong(8);
        this.m_cInProgress = in.readLong(9);
    }

    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, (Object)this.m_state);
        out.writeString(1, this.m_sIdentity);
        out.writeObject(2, this.m_optionsByType);
        out.writeLong(3, this.m_ldtUpdate);
        out.writeLong(4, this.m_cMaxMemory);
        out.writeLong(5, this.m_cTotalMemory);
        out.writeLong(6, this.m_cFreeMemory);
        out.writeLong(7, this.m_cCompleted);
        out.writeLong(8, this.m_cRejected);
        out.writeLong(9, this.m_cInProgress);
    }

    public static class UpdateInfoRunnable
    implements Runnable {
        public static volatile boolean s_fPerformUpdate = true;
        protected final String f_sExecutorId;
        protected final CacheService f_cacheService;
        protected final ClusteredRegistration f_clusteredRegistration;
        protected final Executor f_monitoredExecutor;

        public UpdateInfoRunnable(CacheService cacheService, String sExecutorId, Executor executor, ClusteredRegistration clusteredRegistration) {
            this.f_cacheService = cacheService;
            this.f_sExecutorId = sExecutorId;
            this.f_monitoredExecutor = executor;
            this.f_clusteredRegistration = clusteredRegistration;
        }

        @Override
        public void run() {
            if (s_fPerformUpdate) {
                ExecutorTrace.log(() -> String.format("Updating Information for Executor [%s]", this.f_sExecutorId));
                Runtime runtime = Runtime.getRuntime();
                NamedCache cache = this.f_cacheService.ensureCache(ClusteredExecutorInfo.CACHE_NAME, null);
                cache.invoke((Object)this.f_sExecutorId, (InvocableMap.EntryProcessor)new UpdateInfoProcessor(runtime.maxMemory(), runtime.totalMemory(), runtime.freeMemory(), this.f_monitoredExecutor instanceof ExecutorService && ((ExecutorService)this.f_monitoredExecutor).isTerminated(), this.f_clusteredRegistration.getTasksCompletedCount(), this.f_clusteredRegistration.getTasksRejectedCount(), this.f_clusteredRegistration.getTasksInProgressCount()));
            } else {
                ExecutorTrace.log(() -> String.format("Skipping Information Update for Executor [%s]", this.f_sExecutorId));
            }
        }
    }

    public static class UpdateInfoProcessor
    extends PortableAbstractProcessor {
        protected long m_cMaxMemory;
        protected long m_cTotalMemory;
        protected long m_cFreeMemory;
        protected boolean m_fTerminated;
        protected long m_cTasksCompleted;
        protected long m_cTasksFailed;
        protected long m_cTasksInProgress;

        public UpdateInfoProcessor() {
        }

        public UpdateInfoProcessor(long cMaxMemory, long cTotalMemory, long cFreeMemory, boolean fTerminated, long cTasksCompleted, long cTasksFailed, long cTasksInProgress) {
            this.m_cMaxMemory = cMaxMemory;
            this.m_cTotalMemory = cTotalMemory;
            this.m_cFreeMemory = cFreeMemory;
            this.m_fTerminated = fTerminated;
            this.m_cTasksCompleted = cTasksCompleted;
            this.m_cTasksFailed = cTasksFailed;
            this.m_cTasksInProgress = cTasksInProgress;
        }

        public Object process(InvocableMap.Entry entry) {
            if (entry.isPresent()) {
                ClusteredExecutorInfo info = (ClusteredExecutorInfo)entry.getValue();
                info.setMaxMemory(this.m_cMaxMemory);
                info.setTotalMemory(this.m_cTotalMemory);
                info.setFreeMemory(this.m_cFreeMemory);
                info.setTasksCompletedCount(this.m_cTasksCompleted);
                info.setTasksFailedCount(this.m_cTasksFailed);
                info.setTasksInProgressCount(this.m_cTasksInProgress);
                TaskExecutorService.ExecutorInfo.State currentState = info.getState();
                if (this.m_fTerminated && currentState != TaskExecutorService.ExecutorInfo.State.CLOSING && currentState != TaskExecutorService.ExecutorInfo.State.CLOSED) {
                    Logger.fine(() -> String.format("Executor [%s] has been terminated", entry.getKey()));
                    info.setState(TaskExecutorService.ExecutorInfo.State.CLOSING);
                }
                info.touch();
                entry.setValue((Object)info);
            }
            return null;
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_cMaxMemory = in.readLong(0);
            this.m_cTotalMemory = in.readLong(1);
            this.m_cFreeMemory = in.readLong(2);
            this.m_fTerminated = in.readBoolean(3);
            this.m_cTasksCompleted = in.readLong(4);
            this.m_cTasksFailed = in.readLong(5);
            this.m_cTasksInProgress = in.readLong(6);
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeLong(0, this.m_cMaxMemory);
            out.writeLong(1, this.m_cTotalMemory);
            out.writeLong(2, this.m_cFreeMemory);
            out.writeBoolean(3, this.m_fTerminated);
            out.writeLong(4, this.m_cTasksCompleted);
            out.writeLong(5, this.m_cTasksFailed);
            out.writeLong(6, this.m_cTasksInProgress);
        }
    }

    public static class TouchRunnable
    implements Runnable {
        protected final String f_sExecutorId;
        protected final CacheService f_cacheService;

        public TouchRunnable(String sExecutorId, CacheService cacheService) {
            this.f_sExecutorId = sExecutorId;
            this.f_cacheService = cacheService;
        }

        @Override
        public void run() {
            NamedCache cache = this.f_cacheService.ensureCache(ClusteredExecutorInfo.CACHE_NAME, null);
            cache.invoke((Object)this.f_sExecutorId, (InvocableMap.EntryProcessor)new TouchProcessor());
        }
    }

    public static class TouchProcessor
    extends PortableAbstractProcessor {
        public Object process(InvocableMap.Entry entry) {
            if (entry.isPresent()) {
                ClusteredExecutorInfo info = (ClusteredExecutorInfo)entry.getValue();
                info.touch();
                entry.setValue((Object)info);
            }
            return null;
        }
    }

    public static class SetStateProcessor
    extends PortableAbstractProcessor {
        protected TaskExecutorService.ExecutorInfo.State m_previous;
        protected TaskExecutorService.ExecutorInfo.State m_desired;

        public SetStateProcessor() {
        }

        public SetStateProcessor(TaskExecutorService.ExecutorInfo.State desired) {
            this.m_previous = null;
            this.m_desired = desired;
        }

        public SetStateProcessor(TaskExecutorService.ExecutorInfo.State previous, TaskExecutorService.ExecutorInfo.State desired) {
            this.m_previous = previous;
            this.m_desired = desired;
        }

        public Object process(InvocableMap.Entry entry) {
            if (entry.isPresent()) {
                ClusteredExecutorInfo info = (ClusteredExecutorInfo)entry.getValue();
                TaskExecutorService.ExecutorInfo.State existing = info.getState();
                if ((existing.equals((Object)this.m_previous) || this.m_previous == null) && !existing.equals((Object)this.m_desired)) {
                    boolean fValidTransition = true;
                    switch (this.m_desired) {
                        case JOINING: {
                            fValidTransition = false;
                            break;
                        }
                        case RUNNING: {
                            if (existing.equals((Object)TaskExecutorService.ExecutorInfo.State.JOINING) || existing.equals((Object)TaskExecutorService.ExecutorInfo.State.REJECTING)) break;
                            fValidTransition = false;
                            break;
                        }
                        case REJECTING: {
                            if (existing.equals((Object)TaskExecutorService.ExecutorInfo.State.RUNNING)) break;
                            fValidTransition = false;
                            break;
                        }
                        case CLOSING_GRACEFULLY: {
                            if (existing != TaskExecutorService.ExecutorInfo.State.CLOSED && existing != TaskExecutorService.ExecutorInfo.State.CLOSING) break;
                            fValidTransition = false;
                            break;
                        }
                        case CLOSING: {
                            if (!existing.equals((Object)TaskExecutorService.ExecutorInfo.State.CLOSED)) break;
                            fValidTransition = false;
                            break;
                        }
                        case CLOSED: {
                            break;
                        }
                    }
                    if (!fValidTransition) {
                        Logger.warn(() -> String.format("Invalid transition for Executor[%s] from [%s] to [%s].", new Object[]{info.getId(), existing, this.m_desired}));
                        return null;
                    }
                    info.setState(this.m_desired);
                    entry.setValue((Object)info);
                }
                return existing;
            }
            return null;
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_previous = (TaskExecutorService.ExecutorInfo.State)((Object)in.readObject(0));
            this.m_desired = (TaskExecutorService.ExecutorInfo.State)((Object)in.readObject(1));
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeObject(0, (Object)this.m_previous);
            out.writeObject(1, (Object)this.m_desired);
        }
    }

    public static class RemoveContinuation
    implements ComposableContinuation {
        protected final String f_sExecutorId;
        protected final CacheService f_cacheService;

        public RemoveContinuation(String sExecutorId, CacheService cacheService) {
            this.f_sExecutorId = sExecutorId;
            this.f_cacheService = cacheService;
        }

        public void proceed(Object o) {
            this.f_cacheService.ensureCache(ClusteredExecutorInfo.CACHE_NAME, null).remove((Object)this.f_sExecutorId);
            Logger.fine(() -> String.format("Removed Executor [%s]", this.f_sExecutorId));
        }

        @Override
        public ComposableContinuation compose(ComposableContinuation continuation) {
            return continuation;
        }
    }

    public static class JoiningContinuation
    implements ComposableContinuation,
    PortableObject {
        protected String m_sExecutorId;
        protected CacheService m_cacheService;

        public JoiningContinuation() {
        }

        public JoiningContinuation(String sExecutorId, CacheService cacheService) {
            this.m_sExecutorId = sExecutorId;
            this.m_cacheService = cacheService;
        }

        public void proceed(Object o) {
            this.m_cacheService.ensureCache(ClusteredExecutorInfo.CACHE_NAME, null).invoke((Object)this.m_sExecutorId, (InvocableMap.EntryProcessor)new SetStateProcessor(TaskExecutorService.ExecutorInfo.State.JOINING, TaskExecutorService.ExecutorInfo.State.RUNNING));
            this.m_cacheService.ensureCache(ClusteredTaskManager.CACHE_NAME, null).invokeAll((Filter)AlwaysFilter.INSTANCE, (InvocableMap.EntryProcessor)new ClusteredTaskManager.NotifyExecutionStrategyProcessor());
            Logger.fine(() -> String.format("Executor [%s] joined.", this.m_sExecutorId));
        }

        @Override
        public ComposableContinuation compose(ComposableContinuation continuation) {
            return continuation;
        }

        public void readExternal(PofReader pofReader) throws IOException {
        }

        public void writeExternal(PofWriter pofWriter) throws IOException {
        }
    }

    public static class ClosingGracefullyContinuation
    implements ComposableContinuation {
        protected final String m_sExecutorId;
        protected final CacheService f_cacheService;

        public ClosingGracefullyContinuation(String sExecutorId, CacheService cacheService) {
            this.m_sExecutorId = sExecutorId;
            this.f_cacheService = cacheService;
        }

        public void proceed(Object o) {
            long currentTaskCount = this.f_cacheService.ensureCache(ClusteredAssignment.CACHE_NAME, null).stream((Filter)new EqualsFilter("getExecutorId", (Object)this.m_sExecutorId)).count();
            if (currentTaskCount == 0L) {
                this.f_cacheService.ensureCache(ClusteredExecutorInfo.CACHE_NAME, null).invoke((Object)this.m_sExecutorId, (InvocableMap.EntryProcessor)new SetStateProcessor(TaskExecutorService.ExecutorInfo.State.CLOSING));
            } else {
                Logger.finer(() -> String.format("Graceful closing of Executor [%s]. %d assigned task(s) remaining", this.m_sExecutorId, currentTaskCount));
            }
        }

        @Override
        public ComposableContinuation compose(ComposableContinuation continuation) {
            return continuation;
        }

        public String toString() {
            return "ClosingGracefullyContinuation{ExecutorId='" + this.m_sExecutorId + "'}";
        }
    }

    public static class ClosingContinuation
    implements ComposableContinuation {
        protected final String f_sExecutorId;
        protected final CacheService f_cacheService;

        public ClosingContinuation(String sExecutorId, CacheService cacheService) {
            this.f_cacheService = cacheService;
            this.f_sExecutorId = sExecutorId;
        }

        public void proceed(Object o) {
            ExecutorTrace.log(() -> String.format("Closing Executor [%s]", this.f_sExecutorId));
            ExecutorTrace.log(() -> String.format("Determining Tasks Assigned to Executor [%s]", this.f_sExecutorId));
            Map assignmentMap = this.f_cacheService.ensureCache(ClusteredAssignment.CACHE_NAME, null).invokeAll((Filter)new EqualsFilter("getExecutorId", (Object)this.f_sExecutorId), (InvocableMap.EntryProcessor)new ExtractorProcessor("getTaskId"));
            Logger.finer(() -> String.format("Found %d Tasks Assigned to Executor [%s].  Notifying them of the Closing Executor", assignmentMap.size(), this.f_sExecutorId));
            this.f_cacheService.ensureCache(ClusteredTaskManager.CACHE_NAME, null).invokeAll(assignmentMap.values(), (InvocableMap.EntryProcessor)new ClusteredTaskManager.NotifyExecutionStrategyProcessor());
            Logger.finer(() -> String.format("Removing Assignments for Executor [%s]", this.f_sExecutorId));
            this.f_cacheService.ensureCache(ClusteredTaskManager.CACHE_NAME, null).invokeAll(assignmentMap.keySet(), (InvocableMap.EntryProcessor)new ConditionalRemove((Filter)AlwaysFilter.INSTANCE));
            Logger.finer(() -> String.format("Notifying Executor [%s] that it is now Closed", this.f_sExecutorId));
            this.f_cacheService.ensureCache(ClusteredExecutorInfo.CACHE_NAME, null).invoke((Object)this.f_sExecutorId, (InvocableMap.EntryProcessor)new SetStateProcessor(TaskExecutorService.ExecutorInfo.State.CLOSED));
        }

        @Override
        public ComposableContinuation compose(ComposableContinuation continuation) {
            return continuation;
        }
    }
}

