/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.locks.internal.cdi;

import com.oracle.coherence.cdi.Name;
import com.oracle.coherence.cdi.Remote;
import com.oracle.coherence.concurrent.locks.Locks;
import com.oracle.coherence.concurrent.locks.RemoteLock;
import com.oracle.coherence.concurrent.locks.internal.cdi.AbstractLockProducer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.InjectionPoint;

@ApplicationScoped
class LockProducer
extends AbstractLockProducer {
    LockProducer() {
    }

    @Produces
    @Name(value="")
    @Remote
    Lock getLock(InjectionPoint ip) {
        if (ip.getQualifiers().contains(Remote.Literal.INSTANCE)) {
            return this.getRemoteLock(ip);
        }
        return this.getReentrantLock(ip);
    }

    @Produces
    ReentrantLock getUnqualifiedReentrantLock(InjectionPoint ip) {
        return this.getReentrantLock(ip);
    }

    @Produces
    @Name(value="")
    @Typed(value={ReentrantLock.class})
    ReentrantLock getReentrantLock(InjectionPoint ip) {
        return Locks.localLock(this.getName(ip));
    }

    @Produces
    @Typed(value={RemoteLock.class})
    RemoteLock getUnqualifiedRemoteLock(InjectionPoint ip) {
        return this.getRemoteLock(ip);
    }

    @Produces
    @Name(value="")
    @Typed(value={RemoteLock.class})
    RemoteLock getRemoteLock(InjectionPoint ip) {
        return Locks.remoteLock(this.getName(ip));
    }
}

