/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor.function;

import com.oracle.coherence.concurrent.executor.ExecutionPlan;
import com.tangosol.util.function.Remote;
import java.util.Map;

public final class BiPredicates {
    private BiPredicates() {
    }

    public static <T, U> Remote.BiPredicate<T, U> never() {
        return NeverBiPredicate.get();
    }

    public static <T> Remote.BiPredicate<ExecutionPlan, Map<String, T>> all(Remote.Predicate<? super T> predicate) {
        return new AllResultsBiPredicate<T>(predicate);
    }

    public static <T> Remote.BiPredicate<ExecutionPlan, Map<String, T>> any(Remote.Predicate<? super T> predicate) {
        return new AnyResultBiPredicate<T>(predicate);
    }

    public static class NeverBiPredicate
    implements Remote.BiPredicate {
        protected static final NeverBiPredicate INSTANCE = new NeverBiPredicate();

        public boolean test(Object first, Object second) {
            return false;
        }

        public static NeverBiPredicate get() {
            return INSTANCE;
        }
    }

    public static class AnyResultBiPredicate<T>
    implements Remote.BiPredicate<ExecutionPlan, Map<String, T>> {
        private final Remote.Predicate<? super T> f_predicate;

        public AnyResultBiPredicate(Remote.Predicate<? super T> predicate) {
            this.f_predicate = predicate;
        }

        public boolean test(ExecutionPlan plan, Map<String, T> mapResult) {
            boolean fSatisfied = false;
            for (T result : mapResult.values()) {
                if (!(fSatisfied = fSatisfied || this.f_predicate.test(result))) continue;
                break;
            }
            return fSatisfied;
        }
    }

    public static class AllResultsBiPredicate<T>
    implements Remote.BiPredicate<ExecutionPlan, Map<String, T>> {
        private final Remote.Predicate<? super T> f_predicate;

        public AllResultsBiPredicate(Remote.Predicate<? super T> predicate) {
            this.f_predicate = predicate;
        }

        public boolean test(ExecutionPlan plan, Map<String, T> mapResult) {
            if (plan != null && plan.isSatisfied()) {
                boolean fSatisfied = true;
                for (T result : mapResult.values()) {
                    if (fSatisfied = fSatisfied && this.f_predicate.test(result)) continue;
                    break;
                }
                return fSatisfied;
            }
            return false;
        }
    }
}

