/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent;

import com.oracle.coherence.concurrent.PermitAcquirer;
import com.oracle.coherence.concurrent.Semaphore;
import com.oracle.coherence.concurrent.internal.SemaphoreStatus;
import com.tangosol.net.Member;
import com.tangosol.net.NamedMap;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.Processors;
import com.tangosol.util.UID;
import com.tangosol.util.function.Remote;
import com.tangosol.util.listener.SimpleMapListener;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.function.Supplier;

public class RemoteSemaphore
implements Semaphore {
    private final Sync f_sync;

    public RemoteSemaphore(String sName, int permits, NamedMap<String, SemaphoreStatus> semaphores) {
        this.f_sync = new Sync(sName, permits, semaphores);
        semaphores.addMapListener((MapListener)new SimpleMapListener().addUpdateHandler(x$0 -> this.f_sync.onSemaphoreStatusChange((MapEvent<? extends String, ? extends SemaphoreStatus>)x$0)), (Object)sName, false);
    }

    @Override
    public void acquire() throws InterruptedException {
        this.f_sync.acquireSharedInterruptibly(1);
    }

    @Override
    public void acquireUninterruptibly() {
        this.f_sync.acquireShared(1);
    }

    @Override
    public boolean tryAcquire() {
        return this.f_sync.tryAcquireShared(1) >= 0;
    }

    @Override
    public boolean tryAcquire(long timeout, TimeUnit unit) throws InterruptedException {
        return this.f_sync.tryAcquireSharedNanos(1, unit.toNanos(timeout));
    }

    @Override
    public void release() {
        this.f_sync.releaseShared(1);
    }

    @Override
    public void acquire(int permits) throws InterruptedException {
        if (permits < 0) {
            throw new IllegalArgumentException();
        }
        this.f_sync.acquireSharedInterruptibly(permits);
    }

    @Override
    public void acquireUninterruptibly(int permits) {
        if (permits < 0) {
            throw new IllegalArgumentException();
        }
        this.f_sync.acquireShared(permits);
    }

    @Override
    public boolean tryAcquire(int permits) {
        if (permits < 0) {
            throw new IllegalArgumentException();
        }
        return this.f_sync.tryAcquireShared(permits) >= 0;
    }

    @Override
    public boolean tryAcquire(int permits, long timeout, TimeUnit unit) throws InterruptedException {
        if (permits < 0) {
            throw new IllegalArgumentException();
        }
        return this.f_sync.tryAcquireSharedNanos(permits, unit.toNanos(timeout));
    }

    @Override
    public void release(int permits) {
        if (permits < 0) {
            throw new IllegalArgumentException();
        }
        this.f_sync.releaseShared(permits);
    }

    @Override
    public int availablePermits() {
        return this.f_sync.getPermits();
    }

    @Override
    public int drainPermits() {
        return this.f_sync.drainPermits();
    }

    protected void reducePermits(int reduction) {
        if (reduction < 0) {
            throw new IllegalArgumentException();
        }
        this.f_sync.reducePermits(reduction);
    }

    public boolean isAcquiredByCurrentThread() {
        return this.f_sync.isAcquiredByThread(Thread.currentThread());
    }

    public String toString() {
        return super.toString() + "[Permits = " + this.f_sync.getPermits() + "]";
    }

    public int getInitialPermits() {
        return this.f_sync.getInitialPermits();
    }

    static class Sync
    extends AbstractQueuedSynchronizer {
        private final UID f_memberId;
        private final String f_sName;
        private final NamedMap<String, SemaphoreStatus> f_semaphores;
        private final int f_initialPermits;

        Sync(String sName, int permits, NamedMap<String, SemaphoreStatus> semaphores) {
            Member localMember = semaphores.getService().getCluster().getLocalMember();
            this.f_sName = sName;
            this.f_semaphores = semaphores;
            this.f_memberId = localMember.getUid();
            this.f_initialPermits = permits;
            this.setState(permits);
        }

        @Override
        protected int tryAcquireShared(int acquires) {
            if (acquires == -1) {
                return 0;
            }
            int initialPermits = this.f_initialPermits;
            Remote.Supplier & Serializable supplier = (Remote.Supplier & Serializable)() -> new SemaphoreStatus(initialPermits);
            Thread thread = Thread.currentThread();
            PermitAcquirer acquirer = new PermitAcquirer(this.f_memberId, thread.getId());
            Integer acquired = (Integer)this.f_semaphores.invoke((Object)this.f_sName, (InvocableMap.EntryProcessor & Serializable)entry -> {
                SemaphoreStatus semaphoreStatus = (SemaphoreStatus)entry.getValue((Supplier)supplier);
                boolean success = semaphoreStatus.acquire(acquirer, acquires);
                entry.setValue((Object)semaphoreStatus);
                if (success) {
                    return semaphoreStatus.getPermits();
                }
                return -1;
            });
            if (acquired >= 0) {
                this.setState(acquired);
            }
            return acquired;
        }

        @Override
        protected final boolean tryReleaseShared(int releases) {
            if (releases == -1) {
                return true;
            }
            Thread thread = Thread.currentThread();
            PermitAcquirer acquirer = new PermitAcquirer(this.f_memberId, thread.getId());
            Integer state = (Integer)this.f_semaphores.invoke((Object)this.f_sName, (InvocableMap.EntryProcessor & Serializable)entry -> {
                SemaphoreStatus status = (SemaphoreStatus)entry.getValue();
                if (status.release(acquirer, releases)) {
                    entry.setValue((Object)status);
                }
                return status.getPermits();
            });
            if (state == null) {
                throw new IllegalMonitorStateException();
            }
            this.setState(state);
            return state > 0;
        }

        final int drainPermits() {
            Thread thread = Thread.currentThread();
            PermitAcquirer acquirer = new PermitAcquirer(this.f_memberId, thread.getId());
            Integer cur = (Integer)this.f_semaphores.invoke((Object)this.f_sName, (InvocableMap.EntryProcessor & Serializable)entry -> {
                SemaphoreStatus status = (SemaphoreStatus)entry.getValue();
                int drained = status.drainPermits(acquirer);
                entry.setValue((Object)status);
                return drained;
            });
            this.setState(0);
            return cur;
        }

        final void reducePermits(int reductions) {
            Thread thread = Thread.currentThread();
            PermitAcquirer acquirer = new PermitAcquirer(this.f_memberId, thread.getId());
            Integer nextState = (Integer)this.f_semaphores.invoke((Object)this.f_sName, (InvocableMap.EntryProcessor & Serializable)entry -> {
                SemaphoreStatus status = (SemaphoreStatus)entry.getValue();
                int availablePermits = status.reducePermits(acquirer, reductions);
                entry.setValue((Object)status);
                return availablePermits;
            });
            this.setState(nextState);
        }

        final int getPermits() {
            return (Integer)this.f_semaphores.invoke((Object)this.f_sName, Processors.extract(SemaphoreStatus::getPermits));
        }

        public int getInitialPermits() {
            return this.f_initialPermits;
        }

        final boolean isAcquiredByThread(Thread thread) {
            PermitAcquirer acquirer = new PermitAcquirer(this.f_memberId, thread.getId());
            return (Boolean)this.f_semaphores.invoke((Object)this.f_sName, (InvocableMap.EntryProcessor & Serializable)entry -> {
                SemaphoreStatus status = (SemaphoreStatus)entry.getValue();
                return status != null && status.isAcquiredBy(acquirer);
            });
        }

        private void onSemaphoreStatusChange(MapEvent<? extends String, ? extends SemaphoreStatus> event) {
            SemaphoreStatus oldStatus = (SemaphoreStatus)event.getOldValue();
            SemaphoreStatus status = (SemaphoreStatus)event.getNewValue();
            if (oldStatus.getPermits() == status.getPermits()) {
                return;
            }
            if (status.getPermits() <= 0 && !this.f_memberId.equals((Object)status.getMember())) {
                this.acquireShared(-1);
            } else if (status.getPermits() > 0 && status.getPermits() > oldStatus.getPermits() && !this.f_memberId.equals((Object)status.getMember())) {
                this.releaseShared(-1);
            }
        }
    }
}

