/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.internal.cdi;

import com.oracle.coherence.cdi.Name;
import com.oracle.coherence.cdi.Remote;
import com.oracle.coherence.concurrent.CountDownLatch;
import com.oracle.coherence.concurrent.Latches;
import com.oracle.coherence.concurrent.LocalCountDownLatch;
import com.oracle.coherence.concurrent.RemoteCountDownLatch;
import com.oracle.coherence.concurrent.cdi.Count;
import java.lang.reflect.Member;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.DefinitionException;
import javax.enterprise.inject.spi.InjectionPoint;

@ApplicationScoped
public class CountDownLatchProducer {
    @Produces
    @Name(value="")
    @Count
    @Remote
    CountDownLatch getCountDownLatch(InjectionPoint ip) {
        if (ip.getQualifiers().contains(Remote.Literal.INSTANCE)) {
            return this.getRemoteCountDownLatch(ip);
        }
        return this.getLocalCountDownLatch(ip);
    }

    @Produces
    LocalCountDownLatch getUnqualifiedLocalCountDownLatch(InjectionPoint ip) {
        return this.getLocalCountDownLatch(ip);
    }

    @Produces
    @Name(value="")
    @Count
    @Typed(value={LocalCountDownLatch.class})
    LocalCountDownLatch getLocalCountDownLatch(InjectionPoint ip) {
        return Latches.localCountDownLatch(this.getName(ip), this.getCount(ip));
    }

    @Produces
    @Typed(value={RemoteCountDownLatch.class})
    RemoteCountDownLatch getUnqualifiedRemoteCountDownLatch(InjectionPoint ip) {
        return this.getRemoteCountDownLatch(ip);
    }

    @Produces
    @Name(value="")
    @Count
    @Typed(value={RemoteCountDownLatch.class})
    RemoteCountDownLatch getRemoteCountDownLatch(InjectionPoint ip) {
        return Latches.remoteCountDownLatch(this.getName(ip), this.getCount(ip));
    }

    protected String getName(InjectionPoint ip) {
        String sName = ip.getQualifiers().stream().filter(a -> Name.class.equals(a.annotationType())).findFirst().map(a -> ((Name)a).value()).orElse(null);
        if (sName == null || sName.trim().isEmpty()) {
            Member member = ip.getMember();
            if (member == null) {
                String sMsg = "Cannot determine the name of the latch. No @Name qualifier and injection point member is null";
                throw new DefinitionException(sMsg);
            }
            sName = member.getName();
        }
        return sName;
    }

    protected int getCount(InjectionPoint ip) {
        return ip.getQualifiers().stream().filter(a -> Count.class.equals(a.annotationType())).findFirst().map(a -> ((Count)a).value()).orElse(1);
    }
}

