/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.internal;

import com.oracle.coherence.concurrent.PermitAcquirer;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.Member;
import com.tangosol.net.ServiceInfo;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.UUID;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class SemaphoreStatus
implements ExternalizableLite,
PortableObject {
    private int m_permits;
    private UUID m_memberId;
    private int m_initialPermits;
    Map<PermitAcquirer, Integer> m_permitsMap = new HashMap<PermitAcquirer, Integer>();

    public SemaphoreStatus() {
    }

    public SemaphoreStatus(int initialState) {
        this.m_initialPermits = initialState;
        this.m_permits = initialState;
    }

    public boolean acquire(PermitAcquirer acquirer, int permits) {
        if (this.m_permits < permits) {
            return false;
        }
        this.m_permits -= permits;
        this.m_memberId = acquirer.getMemberId();
        this.m_permitsMap.compute(acquirer, (o, acquirersPermits) -> acquirersPermits == null ? permits : acquirersPermits + permits);
        return true;
    }

    public boolean release(PermitAcquirer acquirer, int releases) {
        int current = this.m_permits;
        int next = current + releases;
        if (next < current) {
            throw new Error("Maximum permit count exceeded");
        }
        this.m_permits = next;
        this.m_memberId = acquirer.getMemberId();
        this.m_permitsMap.compute(acquirer, (acq, acquirerPermits) -> {
            if (acquirerPermits == null || acquirerPermits - releases <= 0) {
                return null;
            }
            return acquirerPermits - releases;
        });
        return true;
    }

    public int drainPermits(PermitAcquirer acquirer) {
        int current = this.m_permits;
        this.m_permits = 0;
        this.m_memberId = acquirer.getMemberId();
        this.m_permitsMap.compute(acquirer, (a, acquirersPermits) -> {
            int permits = acquirersPermits == null ? current : acquirersPermits + current;
            return permits == 0 ? null : Integer.valueOf(permits);
        });
        return current;
    }

    public int reducePermits(PermitAcquirer acquirer, int reductions) {
        int current = this.m_permits;
        int next = current - reductions;
        if (next > current) {
            throw new Error("Permit count underflow");
        }
        this.m_permits = next;
        this.m_memberId = acquirer.getMemberId();
        return this.m_permits;
    }

    public int getPermits() {
        return this.m_permits;
    }

    public void setPermits(int permits) {
        this.m_permits = permits;
    }

    public UUID getMember() {
        return this.m_memberId;
    }

    public void setMember(UUID member) {
        this.m_memberId = member;
    }

    public boolean isAcquiredBy(PermitAcquirer acquirer) {
        return this.m_permitsMap.containsKey(acquirer);
    }

    protected boolean retainPermitsFor(Set<UUID> setMemberIds) {
        boolean fModified = false;
        Iterator<Map.Entry<PermitAcquirer, Integer>> it = this.m_permitsMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<PermitAcquirer, Integer> entry = it.next();
            PermitAcquirer acquirer = entry.getKey();
            if (acquirer.isClient() || setMemberIds.contains(acquirer.getMemberId())) continue;
            it.remove();
            fModified = true;
            this.m_permits += entry.getValue().intValue();
        }
        return fModified;
    }

    protected boolean removePermitsFor(UUID memberId) {
        boolean fModified = false;
        Iterator<Map.Entry<PermitAcquirer, Integer>> it = this.m_permitsMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<PermitAcquirer, Integer> entry = it.next();
            if (!entry.getKey().getMemberId().equals((Object)memberId)) continue;
            it.remove();
            fModified = true;
            this.m_permits += entry.getValue().intValue();
        }
        return fModified;
    }

    public int getInitialPermits() {
        return this.m_initialPermits;
    }

    public Map<PermitAcquirer, Integer> getPermitsMap() {
        return Collections.unmodifiableMap(this.m_permitsMap);
    }

    public String toString() {
        return "SemaphoreStatus{m_permits=" + this.m_permits + ", m_memberId=" + String.valueOf(this.m_memberId) + ", m_initialPermits=" + this.m_initialPermits + ", m_permitsMap=" + String.valueOf(this.m_permitsMap) + "}";
    }

    public void readExternal(DataInput in) throws IOException {
        this.m_permits = ExternalizableHelper.readInt((DataInput)in);
        this.m_memberId = (UUID)ExternalizableHelper.readObject((DataInput)in);
        this.m_initialPermits = ExternalizableHelper.readInt((DataInput)in);
        this.m_permitsMap = new HashMap<PermitAcquirer, Integer>();
        ExternalizableHelper.readMap((DataInput)in, this.m_permitsMap, null);
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.m_permits);
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.m_memberId);
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.m_initialPermits);
        ExternalizableHelper.writeMap((DataOutput)out, this.m_permitsMap);
    }

    public void readExternal(PofReader in) throws IOException {
        this.m_permits = in.readInt(0);
        this.m_memberId = (UUID)in.readObject(1);
        this.m_initialPermits = in.readInt(2);
        this.m_permitsMap = in.readMap(3, new HashMap());
    }

    public void writeExternal(PofWriter out) throws IOException {
        out.writeInt(0, this.m_permits);
        out.writeObject(1, (Object)this.m_memberId);
        out.writeInt(2, this.m_initialPermits);
        out.writeMap(3, this.m_permitsMap);
    }

    public static class RemovePermits
    implements InvocableMap.EntryProcessor<String, SemaphoreStatus, Void>,
    ExternalizableLite,
    PortableObject {
        protected UUID m_memberId;

        public RemovePermits() {
        }

        public RemovePermits(UUID memberId) {
            this.m_memberId = memberId;
        }

        public Void process(InvocableMap.Entry<String, SemaphoreStatus> entry) {
            SemaphoreStatus status = (SemaphoreStatus)entry.getValue();
            if (this.m_memberId == null) {
                ServiceInfo info = ((BinaryEntry)entry).getContext().getCacheService().getInfo();
                Set setServiceMembers = info.getServiceMembers();
                Set<UUID> setValidMemberIds = setServiceMembers.stream().map(Member::getUuid).collect(Collectors.toSet());
                if (status.retainPermitsFor(setValidMemberIds)) {
                    entry.setValue((Object)status);
                }
            } else if (status.removePermitsFor(this.m_memberId)) {
                entry.setValue((Object)status);
            }
            return null;
        }

        public void readExternal(DataInput in) throws IOException {
            this.m_memberId = (UUID)ExternalizableHelper.readObject((DataInput)in);
        }

        public void writeExternal(DataOutput out) throws IOException {
            ExternalizableHelper.writeObject((DataOutput)out, (Object)this.m_memberId);
        }

        public void readExternal(PofReader in) throws IOException {
            this.m_memberId = (UUID)in.readObject(0);
        }

        public void writeExternal(PofWriter out) throws IOException {
            out.writeObject(0, (Object)this.m_memberId);
        }
    }
}

