/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor;

import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.concurrent.executor.ComposableContinuation;
import com.oracle.coherence.concurrent.executor.atomic.AtomicEnum;
import com.oracle.coherence.concurrent.executor.internal.ExecutorTrace;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class ContinuationService<T> {
    protected final ConcurrentHashMap<T, ComposableContinuation> f_mapPendingContinuations = new ConcurrentHashMap();
    protected final ExecutorService[] f_aContinuationServices = new ExecutorService[7];
    protected final AtomicEnum<State> f_state;

    public ContinuationService(ThreadFactory threadFactory) {
        for (int i = 0; i < this.f_aContinuationServices.length; ++i) {
            this.f_aContinuationServices[i] = Executors.newSingleThreadExecutor(threadFactory);
        }
        this.f_state = AtomicEnum.of(State.RUNNING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean submit(ComposableContinuation continuation, T object) {
        ExecutorTrace.entering(ContinuationService.class, "submit", continuation, object);
        boolean fResult = false;
        if (this.f_state.get() == State.RUNNING && continuation != null) {
            ConcurrentHashMap<T, ComposableContinuation> mapPendingContinuations = this.f_mapPendingContinuations;
            ExecutorService[] aExecutorServices = this.f_aContinuationServices;
            ConcurrentHashMap<T, ComposableContinuation> concurrentHashMap = mapPendingContinuations;
            synchronized (concurrentHashMap) {
                ComposableContinuation existing = (ComposableContinuation)mapPendingContinuations.get(object);
                ComposableContinuation composed = existing == null ? continuation : existing.compose(continuation);
                ExecutorTrace.log(() -> String.format("Composing existing [%s] with provided [%s]; result [%s]", existing, continuation, composed));
                if (composed != null) {
                    mapPendingContinuations.put(object, composed);
                    if (existing == null) {
                        int index = Math.abs(object.hashCode()) % aExecutorServices.length;
                        if (index < 0) {
                            index = 0;
                        }
                        int nIdx = index;
                        ExecutorService service = aExecutorServices[nIdx];
                        ExecutorTrace.log(() -> String.format("Submitting continuation to executor [%s] at index [%s]", service, nIdx));
                        aExecutorServices[nIdx].submit(new ContinuationRunnable(object, nIdx));
                    }
                }
                fResult = true;
            }
        }
        ExecutorTrace.exiting(ContinuationService.class, "submit", (Object)fResult, new Object[0]);
        return fResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abandon(T object) {
        T t = object;
        synchronized (t) {
            this.f_mapPendingContinuations.remove(object);
        }
    }

    public void shutdown() {
        if (this.f_state.compareAndSet(State.RUNNING, State.SHUTDOWN)) {
            for (ExecutorService executorService : this.f_aContinuationServices) {
                try {
                    executorService.shutdown();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public void shutdownNow() {
        if (this.f_state.compareAndSet(State.RUNNING, State.SHUTDOWN)) {
            for (ExecutorService executorService : this.f_aContinuationServices) {
                try {
                    executorService.shutdownNow();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private static enum State {
        RUNNING,
        SHUTDOWN;

    }

    public class ContinuationRunnable
    implements Runnable {
        protected final T f_object;
        protected final int f_nServiceIndex;

        public ContinuationRunnable(T object, int serviceIndex) {
            this.f_object = object;
            this.f_nServiceIndex = serviceIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ComposableContinuation continuation;
            if (ExecutorTrace.isEnabled()) {
                ExecutorTrace.entering(ContinuationRunnable.class, "run", this.f_object, Integer.toHexString(this.f_object.hashCode()), this.f_nServiceIndex);
            }
            ConcurrentHashMap mapPendingContinuations = ContinuationService.this.f_mapPendingContinuations;
            Object key = this.f_object;
            ConcurrentHashMap concurrentHashMap = mapPendingContinuations;
            synchronized (concurrentHashMap) {
                continuation = (ComposableContinuation)mapPendingContinuations.remove(key);
            }
            if (continuation == null) {
                Logger.fine(() -> String.format("ComposableContinuation for [%s] has been removed (ignoring request)", key));
            } else {
                try {
                    ExecutorTrace.log(() -> String.format("Executing continuation [%s] for [%s]", continuation, key));
                    continuation.proceed(null);
                }
                catch (Throwable t) {
                    Logger.warn(() -> String.format("Failed to execute continuation [%s] for [%s]", continuation, key));
                    Logger.warn((String)"ComposableContinuation encountered", (Throwable)t);
                }
            }
            ExecutorTrace.exiting(ContinuationRunnable.class, "run");
        }
    }
}

