/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.config.builders;

import com.oracle.coherence.concurrent.config.NamedExecutorService;
import com.oracle.coherence.concurrent.config.builders.AbstractExecutorWithFactoryBuilder;
import com.oracle.coherence.concurrent.executor.util.NamedThreadFactory;
import com.tangosol.coherence.config.ParameterList;
import com.tangosol.config.expression.ParameterResolver;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;

public class CachedBuilder
extends AbstractExecutorWithFactoryBuilder<NamedExecutorService> {
    public NamedExecutorService realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) {
        String sName = (String)this.m_name.evaluate(resolver);
        ThreadFactory factory = this.instantiateThreadFactory(sName, resolver, loader, listParameters);
        Supplier<ExecutorService> supplier = factory == null ? Executors::newCachedThreadPool : () -> Executors.newCachedThreadPool(factory);
        NamedExecutorService service = new NamedExecutorService(sName, this.description(factory), supplier);
        this.register(service);
        return service;
    }

    protected String description(ThreadFactory factory) {
        String sFactory = factory == null || NamedThreadFactory.class.equals(factory.getClass()) ? "default" : factory.getClass().getName();
        return String.format("CachedThreadPool(ThreadFactory=%s)", sFactory);
    }
}

