/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.atomic;

import com.oracle.coherence.concurrent.atomic.AsyncAtomicReference;
import com.tangosol.net.AsyncNamedMap;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.function.Remote;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BinaryOperator;
import java.util.function.UnaryOperator;

public class AsyncRemoteAtomicReference<V>
implements AsyncAtomicReference<V> {
    private final AsyncNamedMap<String, AtomicReference<V>> f_mapAtomic;
    private final String f_sName;

    protected AsyncRemoteAtomicReference(AsyncNamedMap<String, AtomicReference<V>> mapAtomic, String sName) {
        this.f_mapAtomic = mapAtomic;
        this.f_sName = sName;
    }

    @Override
    public CompletableFuture<V> get() {
        return this.invoke(AtomicReference::get, false);
    }

    @Override
    public CompletableFuture<Void> set(V newValue) {
        return this.invoke((Remote.Function & Serializable)value -> {
            value.set(newValue);
            return null;
        });
    }

    @Override
    public CompletableFuture<V> getAndSet(V newValue) {
        return this.invoke((Remote.Function & Serializable)value -> value.getAndSet(newValue));
    }

    @Override
    public CompletableFuture<Boolean> compareAndSet(V expectedValue, V newValue) {
        return this.invoke((Remote.Function & Serializable)value -> {
            Object v = value.get();
            if (Objects.equals(v, expectedValue)) {
                value.set(newValue);
                return true;
            }
            return false;
        });
    }

    @Override
    public CompletableFuture<V> getAndUpdate(Remote.UnaryOperator<V> updateFunction) {
        return this.getAndUpdate((UnaryOperator<V>)updateFunction);
    }

    @Override
    public CompletableFuture<V> getAndUpdate(UnaryOperator<V> updateFunction) {
        return this.invoke((Remote.Function & Serializable)value -> value.getAndUpdate(updateFunction));
    }

    @Override
    public CompletableFuture<V> updateAndGet(Remote.UnaryOperator<V> updateFunction) {
        return this.updateAndGet((UnaryOperator<V>)updateFunction);
    }

    @Override
    public CompletableFuture<V> updateAndGet(UnaryOperator<V> updateFunction) {
        return this.invoke((Remote.Function & Serializable)value -> value.updateAndGet(updateFunction));
    }

    @Override
    public CompletableFuture<V> getAndAccumulate(V x, Remote.BinaryOperator<V> accumulatorFunction) {
        return this.getAndAccumulate(x, (BinaryOperator<V>)accumulatorFunction);
    }

    @Override
    public CompletableFuture<V> getAndAccumulate(V x, BinaryOperator<V> accumulatorFunction) {
        return this.invoke((Remote.Function & Serializable)value -> value.getAndAccumulate(x, accumulatorFunction));
    }

    @Override
    public CompletableFuture<V> accumulateAndGet(V x, Remote.BinaryOperator<V> accumulatorFunction) {
        return this.accumulateAndGet(x, (BinaryOperator<V>)accumulatorFunction);
    }

    @Override
    public CompletableFuture<V> accumulateAndGet(V x, BinaryOperator<V> accumulatorFunction) {
        return this.invoke((Remote.Function & Serializable)value -> value.accumulateAndGet(x, accumulatorFunction));
    }

    @Override
    public CompletableFuture<V> compareAndExchange(V expectedValue, V newValue) {
        return this.invoke((Remote.Function & Serializable)value -> {
            Object v = value.get();
            if (v == null) {
                if (expectedValue == null) {
                    value.set(newValue);
                }
            } else if (v.equals(expectedValue)) {
                value.set(newValue);
            }
            return v;
        });
    }

    public String toString() {
        return String.valueOf(this.get().join());
    }

    protected <R> CompletableFuture<R> invoke(Remote.Function<AtomicReference<V>, R> function) {
        return this.invoke(function, true);
    }

    protected <R> CompletableFuture<R> invoke(Remote.Function<AtomicReference<V>, R> function, boolean fMutate) {
        return this.f_mapAtomic.invoke((Object)this.f_sName, (InvocableMap.EntryProcessor & Serializable)entry -> {
            AtomicReference value = (AtomicReference)entry.getValue();
            Object result = function.apply((Object)value);
            if (fMutate) {
                entry.setValue((Object)value);
            }
            return result;
        });
    }
}

