/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.atomic;

import com.oracle.coherence.concurrent.atomic.AsyncAtomicStampedReference;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicStampedReference;

public class AsyncLocalAtomicStampedReference<V>
implements AsyncAtomicStampedReference<V> {
    private final AtomicStampedReference<V> f_value;

    protected AsyncLocalAtomicStampedReference(AtomicStampedReference<V> value) {
        this.f_value = value;
    }

    @Override
    public CompletableFuture<V> getReference() {
        return CompletableFuture.completedFuture(this.f_value.getReference());
    }

    @Override
    public CompletableFuture<Integer> getStamp() {
        return CompletableFuture.completedFuture(this.f_value.getStamp());
    }

    @Override
    public CompletableFuture<V> get(int[] iaStampHolder) {
        return CompletableFuture.completedFuture(this.f_value.get(iaStampHolder));
    }

    @Override
    public CompletableFuture<Boolean> compareAndSet(V expectedReference, V newReference, int nExpectedStamp, int newStamp) {
        return CompletableFuture.completedFuture(this.f_value.compareAndSet(expectedReference, newReference, nExpectedStamp, newStamp));
    }

    @Override
    public CompletableFuture<Void> set(V newReference, int nNewStamp) {
        this.f_value.set(newReference, nNewStamp);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Boolean> attemptStamp(V expectedReference, int nNewStamp) {
        return CompletableFuture.completedFuture(this.f_value.attemptStamp(expectedReference, nNewStamp));
    }

    public String toString() {
        int[] aiStamp = new int[1];
        V value = this.f_value.get(aiStamp);
        return String.valueOf(value) + " (" + aiStamp[0] + ")";
    }
}

