/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.config.builders;

import com.oracle.coherence.concurrent.config.NamedExecutorService;
import com.oracle.coherence.concurrent.config.builders.AbstractExecutorWithFactoryBuilder;
import com.oracle.coherence.concurrent.executor.util.NamedThreadFactory;
import com.tangosol.coherence.config.ParameterList;
import com.tangosol.config.expression.ParameterResolver;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;

public class VirtualPerTaskBuilder
extends AbstractExecutorWithFactoryBuilder<NamedExecutorService> {
    public NamedExecutorService realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) {
        String sName = (String)this.m_name.evaluate(resolver);
        ThreadFactory factory = this.instantiateThreadFactory(sName, resolver, loader, listParameters);
        Supplier<ExecutorService> supplier = factory == null ? Executors::newVirtualThreadPerTaskExecutor : () -> Executors.newThreadPerTaskExecutor(factory);
        NamedExecutorService service = new NamedExecutorService(sName, this.description(factory), supplier);
        this.register(service);
        return service;
    }

    @Override
    protected ThreadFactory instantiateNamedThreadFactory(String sName) {
        return new VirtualNamedThreadFactory(sName);
    }

    protected String description(ThreadFactory factory) {
        String sFactory = factory == null || VirtualNamedThreadFactory.class.equals(factory.getClass()) ? "default" : factory.getClass().getName();
        return String.format("VirtualThreadPerTask(ThreadFactory=%s)", sFactory);
    }

    protected static class VirtualNamedThreadFactory
    extends NamedThreadFactory {
        public VirtualNamedThreadFactory(String f_sName) {
            super(f_sName);
        }

        @Override
        public Thread newThread(Runnable r, String sName) {
            Thread.Builder.OfVirtual builder = Thread.ofVirtual();
            if (sName != null) {
                builder.name(sName);
            }
            return builder.unstarted(r);
        }
    }
}

