/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.config;

import com.tangosol.net.Coherence;
import com.tangosol.net.SessionConfiguration;
import com.tangosol.net.SessionProvider;
import java.util.Optional;

public class ConcurrentServicesSessionConfiguration
implements SessionConfiguration {
    public static String SESSION_NAME = "concurrent";
    public static String CONFIG_URI = "coherence-concurrent-config.xml";
    public static String CLIENT_CONFIG_URI = "coherence-concurrent-client-config.xml";

    public String getName() {
        return SESSION_NAME;
    }

    public String getScopeName() {
        return "$SYS";
    }

    public Optional<String> getConfigUri() {
        return Optional.of(CONFIG_URI);
    }

    public static class ConcurrentServicesSessionProvider
    implements SessionProvider {
        public SessionProvider.Context createSession(SessionConfiguration configuration, SessionProvider.Context context) {
            if (SESSION_NAME.equals(configuration.getName())) {
                Coherence.Mode mode = context.getMode();
                if (mode.isClusterMember()) {
                    return context.createSession(configuration);
                }
                return context.createSession((SessionConfiguration)new ConcurrentServicesSessionConfiguration(){

                    @Override
                    public Optional<String> getConfigUri() {
                        return Optional.of(CLIENT_CONFIG_URI);
                    }
                });
            }
            return context;
        }
    }
}

