/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.cdi;

import com.oracle.coherence.cdi.CdiMapListenerManager;
import com.oracle.coherence.cdi.ExtractorBinding;
import com.oracle.coherence.cdi.ExtractorProducer;
import com.oracle.coherence.cdi.FilterBinding;
import com.oracle.coherence.cdi.FilterProducer;
import com.oracle.coherence.cdi.Name;
import com.oracle.coherence.cdi.SessionName;
import com.oracle.coherence.cdi.View;
import com.tangosol.net.AsyncNamedCache;
import com.tangosol.net.NamedCache;
import com.tangosol.net.NamedMap;
import com.tangosol.net.Session;
import com.tangosol.net.cache.ContinuousQueryCache;
import com.tangosol.util.Filter;
import com.tangosol.util.ValueExtractor;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Disposes;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.Typed;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.DefinitionException;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

@ApplicationScoped
public class NamedCacheProducer {
    private final Map<CacheId, NamedCache> f_cacheInstances = new ConcurrentHashMap<CacheId, NamedCache>();
    private final Map<CacheId, ContinuousQueryCache> f_cqcInstances = new ConcurrentHashMap<CacheId, ContinuousQueryCache>();
    private final BeanManager f_beanManager;
    private final FilterProducer f_filterProducer;
    private final ExtractorProducer f_extractorProducer;
    private final CdiMapListenerManager f_cdiMapListenerManager;

    @Inject
    NamedCacheProducer(BeanManager beanManager, FilterProducer filterProducer, ExtractorProducer extractorProducer, CdiMapListenerManager cdiMapListenerManager) {
        this.f_beanManager = beanManager;
        this.f_filterProducer = filterProducer;
        this.f_extractorProducer = extractorProducer;
        this.f_cdiMapListenerManager = cdiMapListenerManager;
    }

    @Produces
    <K, V> AsyncNamedCache<K, V> getNonQualifiedAsyncNamedCache(InjectionPoint injectionPoint) {
        return this.getAsyncNamedCache(injectionPoint);
    }

    @Produces
    @Name(value="")
    @SessionName(value="")
    <K, V> AsyncNamedCache<K, V> getAsyncNamedCache(InjectionPoint injectionPoint) {
        NamedCache<K, V> cache = this.getCache(injectionPoint);
        return cache.async();
    }

    @Produces
    <K, V> NamedCache<K, V> getNonQualifiedNamedCache(InjectionPoint injectionPoint) {
        return this.getCache(injectionPoint);
    }

    @Produces
    @Name(value="")
    @View
    @SessionName(value="")
    <K, V> NamedCache<K, V> getCache(InjectionPoint injectionPoint) {
        return this.getCacheInternal(injectionPoint, false);
    }

    @Produces
    @Typed(value={ContinuousQueryCache.class})
    <K, V_BACK, V_FRONT> ContinuousQueryCache<K, V_BACK, V_FRONT> getNonQualifiedCQC(InjectionPoint injectionPoint) {
        return this.getCQC(injectionPoint);
    }

    @Produces
    @Name(value="")
    @View
    @SessionName(value="")
    @Typed(value={ContinuousQueryCache.class})
    <K, V_BACK, V_FRONT> ContinuousQueryCache<K, V_BACK, V_FRONT> getCQC(InjectionPoint injectionPoint) {
        return (ContinuousQueryCache)this.getCacheInternal(injectionPoint, true);
    }

    <K, V_BACK, V_FRONT> void destroyCQC(@Disposes ContinuousQueryCache<K, V_BACK, V_FRONT> cqc) {
        this.destroyQualifiedCQC(cqc);
    }

    <K, V_BACK, V_FRONT> void destroyQualifiedCQC(@Disposes @Name(value="") @View @SessionName(value="") ContinuousQueryCache<K, V_BACK, V_FRONT> cqc) {
        cqc.destroy();
    }

    private <K, V, C extends NamedCache<K, V>> C getCacheInternal(InjectionPoint injectionPoint, boolean fView) {
        String sName = null;
        String sSession = "";
        boolean fCacheValues = true;
        for (Annotation annotation : injectionPoint.getQualifiers()) {
            if (Name.class.equals(annotation.annotationType())) {
                sName = ((Name)annotation).value();
                continue;
            }
            if (SessionName.class.equals(annotation.annotationType())) {
                sSession = ((SessionName)annotation).value();
                continue;
            }
            if (!View.class.equals(annotation.annotationType())) continue;
            fView = true;
            fCacheValues = ((View)annotation).cacheValues();
        }
        Member member = injectionPoint.getMember();
        if (sName == null || sName.trim().isEmpty()) {
            if (member == null) {
                throw new DefinitionException("Cannot determine cache name. No @Cache qualifier and injection point member is null");
            }
            sName = member.getName();
        }
        String sSessionName = sSession;
        Instance instance = this.f_beanManager.createInstance().select(Session.class, new Annotation[]{Name.Literal.of(sSessionName)});
        Session session = (Session)instance.get();
        Set<Annotation> qualifiers = this.extractQualifiers(injectionPoint);
        CacheId cacheId = new CacheId(sName, sSessionName);
        NamedCache cache = this.f_cacheInstances.compute(cacheId, (id, current) -> {
            if (current != null && current.isActive()) {
                return current;
            }
            NamedCache c = session.getCache(id.f_cacheName, new NamedMap.Option[0]);
            this.f_cdiMapListenerManager.registerCacheListeners(id.f_cacheName, session.getScopeName(), id.f_sessionName, c.getCacheService().getInfo().getServiceName());
            return c;
        });
        if (fView) {
            boolean fCacheVals = fCacheValues;
            CacheId cqcId = new CacheId(sName, sSessionName, qualifiers);
            return (C)((NamedCache)this.f_cqcInstances.compute(cqcId, (id, current) -> {
                if (current != null && current.isActive()) {
                    return current;
                }
                Filter filter = this.f_filterProducer.getFilter(injectionPoint);
                ValueExtractor extractor = this.f_extractorProducer.getValueExtractor(injectionPoint);
                return new ContinuousQueryCache(cache, filter, fCacheVals, null, extractor);
            }));
        }
        return (C)cache;
    }

    private Set<Annotation> extractQualifiers(InjectionPoint injectionPoint) {
        Annotated annotated = injectionPoint.getAnnotated();
        if (annotated == null) {
            return Collections.emptySet();
        }
        return annotated.getAnnotations().stream().filter(annotation -> annotation.annotationType().isAnnotationPresent(FilterBinding.class) || annotation.annotationType().isAnnotationPresent(ExtractorBinding.class) || annotation.annotationType().isAnnotationPresent(View.class)).collect(Collectors.toSet());
    }

    static class CacheId {
        private final String f_cacheName;
        private final String f_sessionName;
        private final Set<Annotation> f_qualifiers;

        CacheId(String cacheName, String sessionName) {
            this(cacheName, sessionName, null);
        }

        CacheId(String cacheName, String sessionName, Set<Annotation> qualifiers) {
            this.f_cacheName = cacheName;
            this.f_sessionName = sessionName;
            this.f_qualifiers = qualifiers;
        }

        public String getCacheName() {
            return this.f_cacheName;
        }

        public String getSessionName() {
            return this.f_sessionName;
        }

        public Set<Annotation> getQualifiers() {
            return this.f_qualifiers;
        }

        public boolean equals(Object o) {
            if (!(o instanceof CacheId)) {
                return false;
            }
            CacheId cacheId = (CacheId)o;
            return Objects.equals(this.f_cacheName, cacheId.f_cacheName) && Objects.equals(this.f_sessionName, cacheId.f_sessionName) && Objects.equals(this.f_qualifiers, cacheId.f_qualifiers);
        }

        public int hashCode() {
            int result = Objects.hashCode(this.f_cacheName);
            result = 31 * result + Objects.hashCode(this.f_sessionName);
            result = 31 * result + Objects.hashCode(this.f_qualifiers);
            return result;
        }
    }
}

