/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.cdi;

import com.oracle.coherence.cdi.CacheKey;
import com.oracle.coherence.cdi.CacheValue;
import com.oracle.coherence.cdi.SessionName;
import com.oracle.coherence.cdi.events.CacheName;
import com.tangosol.internal.cdi.MethodKey;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.DeploymentException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

final class CdiHelpers {
    private CdiHelpers() {
    }

    static Function<Object[], Object> cacheKeyFunction(AnnotatedMethod<?> method) {
        List parameters = method.getParameters();
        ArrayList<Integer> keyIndices = new ArrayList<Integer>();
        ArrayList<Integer> allIndices = new ArrayList<Integer>();
        for (int i = 0; i < parameters.size(); ++i) {
            AnnotatedParameter annotatedParameter = (AnnotatedParameter)parameters.get(i);
            if (annotatedParameter.getAnnotation(CacheKey.class) != null) {
                keyIndices.add(i);
            }
            if (annotatedParameter.getAnnotation(CacheValue.class) != null) continue;
            allIndices.add(i);
        }
        if (keyIndices.isEmpty()) {
            keyIndices = allIndices;
        }
        if (keyIndices.size() == 1) {
            int index = (Integer)keyIndices.iterator().next();
            return paramValues -> paramValues[index];
        }
        Integer[] indices = keyIndices.toArray(new Integer[0]);
        return paramValues -> new MethodKey(paramValues, indices);
    }

    static String cacheName(Annotated annotatedType, Annotated callable) {
        CacheName cacheName;
        CacheName found;
        CacheName cacheName2 = found = annotatedType == null ? null : (CacheName)annotatedType.getAnnotation(CacheName.class);
        if (callable != null && (cacheName = (CacheName)callable.getAnnotation(CacheName.class)) != null) {
            found = cacheName;
        }
        if (found == null) {
            throw new DeploymentException("CacheName must be defined either on type, method/constructor, or field/parameter. Type " + String.valueOf(annotatedType) + ", callable: " + String.valueOf(callable));
        }
        return found.value();
    }

    static <T> Integer annotatedParameterIndex(List<? extends AnnotatedParameter<? super T>> parameters, Class<? extends Annotation> annotation) {
        return parameters.stream().filter(annotatedParameter -> annotatedParameter.isAnnotationPresent(annotation)).findFirst().map(AnnotatedParameter::getPosition).orElse(null);
    }

    static String sessionName(Annotated annotatedType, Annotated callable) {
        SessionName sessionName = null;
        if (callable != null) {
            sessionName = (SessionName)callable.getAnnotation(SessionName.class);
        }
        if (sessionName == null && annotatedType != null) {
            sessionName = (SessionName)annotatedType.getAnnotation(SessionName.class);
        }
        if (sessionName != null) {
            return sessionName.value();
        }
        return "";
    }
}

