/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.cdi;

import com.oracle.coherence.cdi.CoherenceExtension;
import com.oracle.coherence.event.EventObserverSupport;
import com.oracle.coherence.inject.Name;
import com.tangosol.net.Coherence;
import com.tangosol.net.CoherenceConfiguration;
import com.tangosol.net.SessionConfiguration;
import com.tangosol.net.events.EventInterceptor;
import com.tangosol.net.events.internal.NamedEventInterceptor;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.literal.NamedLiteral;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Singleton;

@ApplicationScoped
public class CoherenceProducer {
    @Produces
    @Singleton
    @Name(value="")
    public Coherence createCoherence(BeanManager beanManager) {
        Coherence coherence = Coherence.client((CoherenceConfiguration)this.createConfiguration(beanManager));
        coherence.start().join();
        return coherence;
    }

    protected CoherenceConfiguration createConfiguration(BeanManager beanManager) {
        CoherenceExtension extension = (CoherenceExtension)beanManager.getExtension(CoherenceExtension.class);
        List<EventObserverSupport.EventHandler<?, ?>> listInterceptors = extension.getInterceptors();
        Instance configurations = beanManager.createInstance().select(SessionConfiguration.class, new Annotation[]{Any.Literal.INSTANCE});
        Instance interceptorProviders = beanManager.createInstance().select(CoherenceExtension.InterceptorProvider.class, new Annotation[]{Any.Literal.INSTANCE});
        List listInterceptor = listInterceptors.stream().map(handler -> new NamedEventInterceptor(handler.getId(), (EventInterceptor)handler)).collect(Collectors.toList());
        interceptorProviders.stream().flatMap(provider -> StreamSupport.stream(provider.getInterceptors().spliterator(), false)).forEach(listInterceptor::add);
        Instance instance = beanManager.createInstance().select(CoherenceConfiguration.Builder.class, new Annotation[]{NamedLiteral.of((String)"")});
        CoherenceConfiguration.Builder builder = instance.isResolvable() ? (CoherenceConfiguration.Builder)instance.get() : CoherenceConfiguration.builder().withSession(SessionConfiguration.defaultSession()).withSessions((Iterable)configurations).withEventInterceptors(listInterceptor).discoverSessions();
        return builder.named("").build();
    }
}

