/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.cdi;

import com.oracle.coherence.cdi.AlwaysFilter;
import com.oracle.coherence.cdi.AnnotationInstance;
import com.oracle.coherence.cdi.FilterBinding;
import com.oracle.coherence.cdi.FilterFactory;
import com.oracle.coherence.cdi.WhereFilter;
import com.tangosol.util.Filter;
import com.tangosol.util.Filters;
import com.tangosol.util.QueryHelper;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.DefinitionException;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;

@ApplicationScoped
public class FilterProducer {
    private final BeanManager f_beanManager;
    private final FilterFactoryResolver f_filterFactoryResolver;

    @Inject
    FilterProducer(BeanManager beanManager, FilterFactoryResolver resolver) {
        this.f_beanManager = beanManager;
        this.f_filterFactoryResolver = resolver;
    }

    @Produces
    public <T> Filter<T> getFilter(InjectionPoint injectionPoint) {
        Annotated annotated = injectionPoint.getAnnotated();
        if (annotated != null) {
            return this.resolve(annotated.getAnnotations());
        }
        return Filters.always();
    }

    <T> Filter<T> resolve(Set<Annotation> annotations) {
        ArrayList list = new ArrayList();
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().isAnnotationPresent(FilterBinding.class)) continue;
            Class<FilterFactory<Annotation, ?>> clazz = this.f_filterFactoryResolver.resolve(annotation);
            if (clazz != null) {
                FilterFactory supplier = (FilterFactory)this.f_beanManager.createInstance().select(clazz, new Annotation[0]).get();
                if (supplier == null) continue;
                list.add(supplier.create(annotation));
                continue;
            }
            throw new DefinitionException("Unsatisfied dependency - no FilterFactory bean found annotated with " + annotation);
        }
        Filter[] aFilters = list.toArray(new Filter[0]);
        if (aFilters.length == 0) {
            return Filters.always();
        }
        if (aFilters.length == 1) {
            return aFilters[0];
        }
        return Filters.all((Filter[])aFilters);
    }

    static class FilterFactoryResolver {
        private Map<AnnotationInstance, Class<? extends FilterFactory<?, ?>>> m_mapFilterFactory;

        FilterFactoryResolver(Map<AnnotationInstance, Class<? extends FilterFactory<?, ?>>> mapFilterFactory) {
            this.m_mapFilterFactory = mapFilterFactory;
        }

        <A extends Annotation> Class<? extends FilterFactory<A, ?>> resolve(A annotation) {
            AnnotationInstance instance = AnnotationInstance.create(annotation);
            return this.m_mapFilterFactory.get(instance);
        }
    }

    @WhereFilter(value="")
    @ApplicationScoped
    public static class WhereFilterSupplier
    implements FilterFactory<WhereFilter, Object> {
        @Override
        public Filter<Object> create(WhereFilter annotation) {
            String where = annotation.value();
            if (where.trim().isEmpty()) {
                return Filters.always();
            }
            return QueryHelper.createFilter((String)where);
        }
    }

    @AlwaysFilter
    @ApplicationScoped
    public static class AlwaysFilterSupplier
    implements FilterFactory<AlwaysFilter, Object> {
        @Override
        public Filter<Object> create(AlwaysFilter annotation) {
            return Filters.always();
        }
    }
}

