/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.cdi;

import com.oracle.coherence.cdi.AnnotationInstance;
import com.oracle.coherence.cdi.CdiMapListener;
import com.oracle.coherence.cdi.ExtractorBinding;
import com.oracle.coherence.cdi.ExtractorFactory;
import com.oracle.coherence.cdi.ExtractorProducer;
import com.oracle.coherence.cdi.FilterBinding;
import com.oracle.coherence.cdi.FilterFactory;
import com.oracle.coherence.cdi.FilterProducer;
import com.oracle.coherence.cdi.MapEventTransformerBinding;
import com.oracle.coherence.cdi.MapEventTransformerFactory;
import com.oracle.coherence.cdi.MapEventTransformerProducer;
import com.tangosol.util.MapEvent;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessObserverMethod;
import javax.enterprise.inject.spi.WithAnnotations;

public class CoherenceExtension
implements Extension {
    private final Map<String, Map<String, Set<CdiMapListener<?, ?>>>> m_mapListeners = new HashMap();
    private final Map<AnnotationInstance, Class<? extends FilterFactory<?, ?>>> m_mapFilterSupplier = new HashMap();
    private final Map<AnnotationInstance, Class<? extends ExtractorFactory<?, ?, ?>>> m_mapExtractorSupplier = new HashMap();
    private final Map<AnnotationInstance, Class<? extends MapEventTransformerFactory<?, ?, ?, ?>>> m_mapMapEventTransformerSupplier = new HashMap();

    private <K, V> void processMapEventObservers(@Observes ProcessObserverMethod<MapEvent<K, V>, ?> event) {
        this.addMapListener(new CdiMapListener(event.getObserverMethod(), event.getAnnotatedMethod().getAnnotations()));
    }

    private <T extends FilterFactory<?, ?>> void processFilterInjectionPoint(@Observes @WithAnnotations(value={FilterBinding.class}) ProcessAnnotatedType<T> event) {
        AnnotatedType type = event.getAnnotatedType();
        type.getAnnotations().stream().filter(a -> a.annotationType().isAnnotationPresent(FilterBinding.class)).map(AnnotationInstance::create).forEach(a -> this.m_mapFilterSupplier.put((AnnotationInstance)a, type.getJavaClass()));
    }

    private <T extends ExtractorFactory<?, ?, ?>> void processValueExtractorInjectionPoint(@Observes @WithAnnotations(value={ExtractorBinding.class}) ProcessAnnotatedType<T> event) {
        AnnotatedType type = event.getAnnotatedType();
        type.getAnnotations().stream().filter(a -> a.annotationType().isAnnotationPresent(ExtractorBinding.class)).map(AnnotationInstance::create).forEach(a -> this.m_mapExtractorSupplier.put((AnnotationInstance)a, type.getJavaClass()));
    }

    private <T extends MapEventTransformerFactory<?, ?, ?, ?>> void processMapEventTransformerInjectionPoint(@Observes @WithAnnotations(value={MapEventTransformerBinding.class}) ProcessAnnotatedType<T> event) {
        AnnotatedType type = event.getAnnotatedType();
        type.getAnnotations().stream().filter(a -> a.annotationType().isAnnotationPresent(MapEventTransformerBinding.class)).map(AnnotationInstance::create).forEach(a -> this.m_mapMapEventTransformerSupplier.put((AnnotationInstance)a, type.getJavaClass()));
    }

    private void addBeans(@Observes AfterBeanDiscovery event) {
        FilterProducer.FilterFactoryResolver filterResolver = new FilterProducer.FilterFactoryResolver(this.m_mapFilterSupplier);
        event.addBean().produceWith(i -> filterResolver).types(new Type[]{FilterProducer.FilterFactoryResolver.class}).qualifiers(new Annotation[]{Default.Literal.INSTANCE}).scope(ApplicationScoped.class).beanClass(FilterProducer.FilterFactoryResolver.class);
        ExtractorProducer.ValueExtractorFactoryResolver extractorResolver = new ExtractorProducer.ValueExtractorFactoryResolver(this.m_mapExtractorSupplier);
        event.addBean().produceWith(i -> extractorResolver).types(new Type[]{ExtractorProducer.ValueExtractorFactoryResolver.class}).qualifiers(new Annotation[]{Default.Literal.INSTANCE}).scope(ApplicationScoped.class).beanClass(ExtractorProducer.ValueExtractorFactoryResolver.class);
        MapEventTransformerProducer.MapEventTransformerFactoryResolver mapEventTransformerResolver = new MapEventTransformerProducer.MapEventTransformerFactoryResolver(this.m_mapMapEventTransformerSupplier);
        event.addBean().produceWith(i -> mapEventTransformerResolver).types(new Type[]{MapEventTransformerProducer.MapEventTransformerFactoryResolver.class}).qualifiers(new Annotation[]{Default.Literal.INSTANCE}).scope(ApplicationScoped.class).beanClass(MapEventTransformerProducer.MapEventTransformerFactoryResolver.class);
    }

    private void addMapListener(CdiMapListener<?, ?> listener) {
        String svc = listener.getServiceName();
        String cache = listener.getCacheName();
        Map mapByCache = this.m_mapListeners.computeIfAbsent(svc, s -> new HashMap());
        Set setListeners = mapByCache.computeIfAbsent(cache, c -> new HashSet());
        setListeners.add(listener);
    }

    public Set<CdiMapListener<?, ?>> getMapListeners(String serviceName, String cacheName) {
        HashSet setResults = new HashSet();
        this.collectMapListeners(setResults, "*", "*");
        this.collectMapListeners(setResults, "*", cacheName);
        this.collectMapListeners(setResults, serviceName, "*");
        this.collectMapListeners(setResults, serviceName, cacheName);
        return setResults;
    }

    public Set<CdiMapListener<?, ?>> getRemoteMapListeners() {
        return this.m_mapListeners.values().stream().flatMap(map -> map.values().stream()).flatMap(Collection::stream).filter(CdiMapListener::isRemote).filter(listener -> !listener.isWildCardCacheName()).collect(Collectors.toSet());
    }

    private void collectMapListeners(HashSet<CdiMapListener<?, ?>> setResults, String serviceName, String cacheName) {
        Map<String, Set<CdiMapListener<?, ?>>> mapByCache = this.m_mapListeners.get(serviceName);
        if (mapByCache != null) {
            setResults.addAll(mapByCache.getOrDefault(cacheName, Collections.emptySet()));
        }
    }
}

