/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.cdi.server;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.LogManager;
import java.util.logging.Logger;

final class LogConfig {
    private static final String LOGGING_FILE = "logging.properties";
    private static final String SYS_PROP_LOGGING_CLASS = "java.util.logging.config.class";
    private static final String SYS_PROP_LOGGING_FILE = "java.util.logging.config.file";

    private LogConfig() {
    }

    static void configureLogging() {
        try {
            LogConfig.doConfigureLogging();
        }
        catch (IOException e) {
            System.err.println("Failed to configure logging");
            e.printStackTrace();
        }
    }

    private static void doConfigureLogging() throws IOException {
        Object sSource;
        String sConfigClass = System.getProperty(SYS_PROP_LOGGING_CLASS);
        String sConfigPath = System.getProperty(SYS_PROP_LOGGING_FILE);
        if (sConfigClass != null) {
            sSource = "class: " + sConfigClass;
        } else if (sConfigPath != null) {
            Path path = Paths.get(sConfigPath, new String[0]);
            sSource = path.toAbsolutePath().toString();
        } else {
            sSource = LogConfig.findAndConfigureLogging();
        }
        Logger.getLogger(LogConfig.class.getName()).info("Logging configured using " + (String)sSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String findAndConfigureLogging() throws IOException {
        Object sSource = "defaults";
        BufferedInputStream logConfigStream = null;
        Path path = Paths.get("", new String[0]).resolve(LOGGING_FILE);
        if (Files.exists(path, new LinkOption[0])) {
            logConfigStream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
            sSource = "file: " + String.valueOf(path.toAbsolutePath());
        } else {
            InputStream resourceStream = LogConfig.class.getResourceAsStream("/logging.properties");
            if (null != resourceStream) {
                logConfigStream = new BufferedInputStream(resourceStream);
                sSource = "classpath: /logging.properties";
            }
        }
        if (null != logConfigStream) {
            try {
                LogManager.getLogManager().readConfiguration(logConfigStream);
            }
            finally {
                ((InputStream)logConfigStream).close();
            }
        }
        return sSource;
    }
}

