/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.cdi.server;

import com.oracle.coherence.cdi.Scope;
import com.oracle.coherence.cdi.server.CacheFactoryUriResolver;
import com.oracle.coherence.cdi.server.CoherenceServerExtension;
import com.tangosol.net.CacheFactoryBuilder;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.util.Base;
import java.lang.reflect.Member;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;

@ApplicationScoped
class ConfigurableCacheFactoryProducer {
    private final BeanManager f_beanManager;
    private final CoherenceServerExtension f_extension;
    private final CacheFactoryUriResolver f_uriResolver;

    @Inject
    ConfigurableCacheFactoryProducer(BeanManager beanManager, CoherenceServerExtension extension, CacheFactoryUriResolver uriResolver) {
        this.f_beanManager = beanManager;
        this.f_extension = extension;
        this.f_uriResolver = uriResolver;
    }

    @Produces
    public ConfigurableCacheFactory getDefaultConfigurableCacheFactory() {
        return this.f_extension.getDefaultCacheFactory();
    }

    @Produces
    @Scope
    public ConfigurableCacheFactory getNamedConfigurableCacheFactory(InjectionPoint injectionPoint) {
        String sScope = injectionPoint.getQualifiers().stream().filter(q -> q.annotationType().isAssignableFrom(Scope.class)).map(q -> ((Scope)q).value()).findFirst().orElse(null);
        return this.getConfigurableCacheFactory(sScope, injectionPoint);
    }

    void disposeConfigurableCacheFactory(@Disposes ConfigurableCacheFactory ccf) {
        ccf.dispose();
    }

    void disposeQualifiedConfigurableCacheFactory(@Disposes @Scope ConfigurableCacheFactory ccf) {
        ccf.dispose();
    }

    @Produces
    public CacheFactoryBuilder getCacheFactoryBuilder() {
        return this.f_extension.getCacheFactoryBuilder();
    }

    ConfigurableCacheFactory getConfigurableCacheFactory(String sScope, InjectionPoint injectionPoint) {
        Member member;
        if (sScope == null || sScope.trim().isEmpty()) {
            return this.getDefaultConfigurableCacheFactory();
        }
        ConfigurableCacheFactory ccf = this.f_extension.getCacheFactoryBuilder().getConfigurableCacheFactory(sScope);
        if (ccf != null) {
            return ccf;
        }
        String sUri = this.f_uriResolver.resolve(sScope);
        if (sUri == null || sUri.trim().isEmpty()) {
            sUri = "$Default$";
        }
        ClassLoader loader = (member = injectionPoint.getMember()) == null ? Base.getContextClassLoader() : member.getDeclaringClass().getClassLoader();
        ccf = this.getCacheFactoryBuilder().getConfigurableCacheFactory(sUri, loader);
        if (ccf.getResourceRegistry().getResource(BeanManager.class, "beanManager") == null) {
            this.f_extension.initializeConfigurableCacheFactory(ccf);
        }
        return ccf;
    }
}

