/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.coherence;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.runtime.Assembly;
import com.oracle.bedrock.runtime.coherence.CoherenceCluster;
import com.oracle.bedrock.runtime.coherence.CoherenceClusterMember;
import com.oracle.bedrock.runtime.coherence.CoherenceNamedCache;
import com.oracle.bedrock.runtime.coherence.callables.GetSession;
import com.oracle.bedrock.runtime.coherence.callables.GetSessionCache;
import com.oracle.bedrock.runtime.concurrent.RemoteCallable;
import com.oracle.bedrock.runtime.concurrent.callable.RemoteMethodInvocation;
import com.oracle.bedrock.util.ReflectionHelper;
import com.tangosol.net.NamedCache;
import com.tangosol.net.NamedCollection;
import com.tangosol.net.NamedMap;
import com.tangosol.net.Service;
import com.tangosol.net.Session;
import com.tangosol.net.events.InterceptorRegistry;
import com.tangosol.net.topic.NamedTopic;
import com.tangosol.util.ResourceRegistry;
import com.tangosol.util.SimpleResourceRegistry;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class CoherenceSession
implements Session {
    private CoherenceClusterMember member;
    private final Optional<CoherenceCluster> cluster;
    private final String coherenceName;
    private final String sessionName;
    private final RemoteCallable<Session> producer;
    private final RemoteMethodInvocation.Interceptor interceptor;
    private final ResourceRegistry registry;

    public CoherenceSession(CoherenceClusterMember member, String coherenceName, String sessionName) {
        this(member, coherenceName, sessionName, new GetSession(coherenceName, sessionName));
    }

    public CoherenceSession(CoherenceClusterMember member, String coherenceName, String sessionName, RemoteCallable<Session> producer) {
        this.member = member;
        this.coherenceName = coherenceName;
        this.sessionName = sessionName;
        this.producer = producer;
        this.interceptor = new SessionMethodInterceptor();
        this.registry = new SimpleResourceRegistry();
        Assembly assembly = (Assembly)member.get(Assembly.class);
        this.cluster = assembly instanceof CoherenceCluster ? Optional.of((CoherenceCluster)assembly) : Optional.empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected <T> T remotelyInvoke(String methodName, Object ... arguments) {
        Method method = ReflectionHelper.getCompatibleMethod(Session.class, (String)methodName, (Object[])arguments);
        if (method == null) {
            throw new UnsupportedOperationException("Unable to locate method [" + methodName + "] with arguments [" + Arrays.toString(arguments) + "] on Session interface");
        }
        this.interceptor.onBeforeRemoteInvocation(method, arguments);
        int retryCount = 0;
        while ((long)retryCount < (this.cluster.isPresent() ? this.cluster.get().count() : 1L)) {
            boolean chooseNewMember;
            boolean bl = chooseNewMember = !this.member.isOperational() || retryCount > 0;
            if (chooseNewMember) {
                if (!this.cluster.isPresent()) throw new IllegalStateException("The underlying Cluster Member [" + this.member.getName() + "] is no longer available to perform the request [" + methodName + "]");
                Optional optional = this.cluster.get().findAny();
                if (!optional.isPresent()) throw new IllegalStateException("The underlying Cluster no longer has available Cluster Members to perform the request [" + methodName + "]");
                this.member = (CoherenceClusterMember)optional.get();
            }
            try {
                CompletableFuture future = this.member.submit((RemoteCallable)new RemoteMethodInvocation(this.producer, methodName, arguments, this.interceptor), new Option[0]);
                return (T)this.interceptor.onAfterRemoteInvocation(method, arguments, future.get());
            }
            catch (IllegalStateException e) {
                ++retryCount;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to execute [" + methodName + "] with arguments " + Arrays.toString(arguments), this.interceptor.onRemoteInvocationException(method, arguments, e));
            }
        }
        throw new IllegalStateException("Failed to perform request [" + methodName + "] with arguments " + Arrays.toString(arguments) + " using [" + retryCount + "] Cluster Members");
    }

    public <K, V> NamedCache<K, V> getCache(String cacheName, NamedMap.Option ... options) {
        return new CoherenceNamedCache<Object, Object>(this.member, cacheName, Object.class, Object.class, new GetSessionCache(this.coherenceName, this.sessionName, cacheName));
    }

    public <V> NamedTopic<V> getTopic(String sName, NamedCollection.Option ... options) {
        throw new UnsupportedOperationException();
    }

    public void close() throws Exception {
        throw new UnsupportedOperationException("The method Session.close() is not supported for remote execution");
    }

    public <K, V> NamedMap<K, V> getMap(String mapName, NamedMap.Option ... options) {
        return this.getCache(mapName, options);
    }

    public ResourceRegistry getResourceRegistry() {
        return this.registry;
    }

    public InterceptorRegistry getInterceptorRegistry() {
        throw new UnsupportedOperationException("The method Session.getInterceptorRegistry() is not supported for remote execution");
    }

    public boolean isMapActive(String mapName, ClassLoader loader) {
        return (Boolean)this.remotelyInvoke("isMapActive", mapName, null);
    }

    public boolean isCacheActive(String cacheName, ClassLoader loader) {
        return (Boolean)this.remotelyInvoke("isCacheActive", cacheName, null);
    }

    public boolean isTopicActive(String topicName, ClassLoader loader) {
        return (Boolean)this.remotelyInvoke("isTopicActive", topicName, null);
    }

    public String getName() {
        return this.sessionName;
    }

    public String getScopeName() {
        return (String)this.remotelyInvoke("getScopeName", new Object[0]);
    }

    public boolean isActive() {
        return (Boolean)this.remotelyInvoke("isActive", new Object[0]);
    }

    public void activate() {
        this.remotelyInvoke("activate", new Object[0]);
    }

    public Service getService(String sServiceName) {
        throw new UnsupportedOperationException("The method Session.getService() is not supported for remote execution");
    }

    public static class SessionMethodInterceptor
    implements RemoteMethodInvocation.Interceptor {
        public void onBeforeRemoteInvocation(Method method, Object[] arguments) {
        }

        public Object onAfterRemoteInvocation(Method method, Object[] arguments, Object result) {
            return result;
        }

        public Exception onRemoteInvocationException(Method method, Object[] arguments, Exception exception) {
            return exception;
        }

        public void onBeforeInvocation(Object instance, Method method, Object[] arguments) {
        }

        public Object onAfterInvocation(Object instance, Method method, Object[] arguments, Object result) {
            return result;
        }

        public Exception onInvocationException(Object instance, Method method, Object[] arguments, Exception exception) {
            return exception;
        }
    }
}

