/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.coherence;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.coherence.CoherenceClusterMember;
import com.oracle.bedrock.runtime.coherence.CoherenceNamedCache;
import com.oracle.bedrock.runtime.coherence.CoherenceSession;
import com.oracle.bedrock.runtime.coherence.ServiceStatus;
import com.oracle.bedrock.runtime.coherence.callables.GetClusterMemberUIDs;
import com.oracle.bedrock.runtime.coherence.callables.GetClusterName;
import com.oracle.bedrock.runtime.coherence.callables.GetClusterSize;
import com.oracle.bedrock.runtime.coherence.callables.GetExtendConnectionCount;
import com.oracle.bedrock.runtime.coherence.callables.GetLocalMemberId;
import com.oracle.bedrock.runtime.coherence.callables.GetLocalMemberMachineName;
import com.oracle.bedrock.runtime.coherence.callables.GetLocalMemberName;
import com.oracle.bedrock.runtime.coherence.callables.GetLocalMemberRackName;
import com.oracle.bedrock.runtime.coherence.callables.GetLocalMemberRoleName;
import com.oracle.bedrock.runtime.coherence.callables.GetLocalMemberSiteName;
import com.oracle.bedrock.runtime.coherence.callables.GetLocalMemberUID;
import com.oracle.bedrock.runtime.coherence.callables.GetLocalMemberUUID;
import com.oracle.bedrock.runtime.coherence.callables.GetServiceStatus;
import com.oracle.bedrock.runtime.coherence.callables.GetSessionCache;
import com.oracle.bedrock.runtime.coherence.callables.HasExtendConnection;
import com.oracle.bedrock.runtime.coherence.callables.IsCoherenceRunning;
import com.oracle.bedrock.runtime.coherence.callables.IsReady;
import com.oracle.bedrock.runtime.coherence.callables.IsSafe;
import com.oracle.bedrock.runtime.coherence.callables.IsServiceRunning;
import com.oracle.bedrock.runtime.coherence.callables.IsServiceStorageEnabled;
import com.oracle.bedrock.runtime.coherence.callables.SessionExists;
import com.oracle.bedrock.runtime.java.AbstractJavaApplication;
import com.oracle.bedrock.runtime.java.JavaApplicationProcess;
import com.oracle.bedrock.runtime.java.features.JmxFeature;
import com.oracle.bedrock.util.Trilean;
import com.tangosol.net.NamedCache;
import com.tangosol.net.Session;
import com.tangosol.util.UID;
import com.tangosol.util.UUID;
import java.util.Set;
import javax.management.MBeanInfo;
import javax.management.ObjectName;

public abstract class AbstractCoherenceClusterMember
extends AbstractJavaApplication<JavaApplicationProcess>
implements CoherenceClusterMember {
    public static final String MBEAN_NAME_CLUSTER = "Coherence:type=Cluster";

    public AbstractCoherenceClusterMember(Platform platform, JavaApplicationProcess process, OptionsByType optionsByType) {
        super(platform, process, optionsByType);
    }

    public MBeanInfo getClusterMBeanInfo() {
        JmxFeature jmxFeature = (JmxFeature)this.get(JmxFeature.class);
        if (jmxFeature == null) {
            throw new UnsupportedOperationException("The JmxFeature (Java Management Extensions) haven't been enabled for this application");
        }
        try {
            return jmxFeature.getMBeanInfo(new ObjectName(MBEAN_NAME_CLUSTER));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Could not retrieve the Coherence Cluster MBean", e);
        }
    }

    @Override
    public int getClusterSize() {
        return (Integer)this.invoke(new GetClusterSize(), new Option[0]);
    }

    @Override
    public int getLocalMemberId() {
        return (Integer)this.invoke(new GetLocalMemberId(), new Option[0]);
    }

    @Override
    public UID getLocalMemberUID() {
        return (UID)this.invoke(new GetLocalMemberUID(), new Option[0]);
    }

    @Override
    public UUID getLocalMemberUUID() {
        return (UUID)this.invoke(new GetLocalMemberUUID(), new Option[0]);
    }

    @Override
    public Set<UID> getClusterMemberUIDs() {
        return (Set)this.invoke(new GetClusterMemberUIDs(), new Option[0]);
    }

    public MBeanInfo getServiceMBeanInfo(String serviceName, int nodeId) {
        JmxFeature jmxFeature = (JmxFeature)this.get(JmxFeature.class);
        if (jmxFeature == null) {
            throw new UnsupportedOperationException("The JmxFeature (Java Management Extensions) haven't been enabled for this application");
        }
        try {
            return jmxFeature.getMBeanInfo(new ObjectName(String.format("Coherence:type=Service,name=%s,nodeId=%d", serviceName, nodeId)));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(String.format("Could not retrieve the Coherence Service MBean [%s]", serviceName), e);
        }
    }

    @Override
    public String getMachineName() {
        return (String)this.invoke(new GetLocalMemberMachineName(), new Option[0]);
    }

    @Override
    public String getMemberName() {
        return (String)this.invoke(new GetLocalMemberName(), new Option[0]);
    }

    @Override
    public String getRoleName() {
        return (String)this.invoke(new GetLocalMemberRoleName(), new Option[0]);
    }

    @Override
    public String getRackName() {
        return (String)this.invoke(new GetLocalMemberRackName(), new Option[0]);
    }

    @Override
    public String getSiteName() {
        return (String)this.invoke(new GetLocalMemberSiteName(), new Option[0]);
    }

    @Override
    public String getClusterName() {
        return (String)this.invoke(new GetClusterName(), new Option[0]);
    }

    @Override
    public <K, V> NamedCache<K, V> getCache(String cacheName) {
        return this.getCache(cacheName, Object.class, Object.class);
    }

    @Override
    public <K, V> NamedCache<K, V> getCache(String cacheName, Class<K> keyClass, Class<V> valueClass) {
        return new CoherenceNamedCache<K, V>(this, cacheName, keyClass, valueClass);
    }

    @Override
    public <K, V> NamedCache<K, V> getCache(String sessionName, String cacheName) {
        return this.getCache("", sessionName, cacheName, Object.class, Object.class);
    }

    @Override
    public <K, V> NamedCache<K, V> getCache(String sessionName, String cacheName, Class<K> keyClass, Class<V> valueClass) {
        return this.getCache("", sessionName, cacheName, keyClass, valueClass);
    }

    @Override
    public <K, V> NamedCache<K, V> getCache(String coherenceName, String sessionName, String cacheName) {
        return this.getCache(coherenceName, sessionName, cacheName, Object.class, Object.class);
    }

    @Override
    public <K, V> NamedCache<K, V> getCache(String coherenceName, String sessionName, String cacheName, Class<K> keyClass, Class<V> valueClass) {
        return new CoherenceNamedCache<K, V>(this, cacheName, keyClass, valueClass, new GetSessionCache(coherenceName, sessionName, cacheName));
    }

    @Override
    public Session getSession() {
        return this.getSession("", "");
    }

    @Override
    public Session getSession(String sessionName) {
        return this.getSession("", sessionName);
    }

    @Override
    public Session getSession(String coherenceName, String sessionName) {
        if (((Boolean)this.invoke(new SessionExists(coherenceName, sessionName), new Option[0])).booleanValue()) {
            return new CoherenceSession(this, coherenceName, sessionName);
        }
        throw new IllegalArgumentException("No session exists in the remote member named " + sessionName + " in Coherence instance named " + coherenceName);
    }

    @Override
    public boolean isServiceRunning(String serviceName) {
        return (Boolean)this.invoke(new IsServiceRunning(serviceName), new Option[0]);
    }

    @Override
    public boolean isCoherenceRunning() {
        return (Boolean)this.invoke(IsCoherenceRunning.instance(), new Option[0]);
    }

    @Override
    public boolean isCoherenceRunning(String sName) {
        return (Boolean)this.invoke(IsCoherenceRunning.named(sName), new Option[0]);
    }

    @Override
    public boolean isSafe() {
        return (Boolean)this.invoke(IsSafe.INSTANCE, new Option[0]);
    }

    @Override
    public boolean isReady() {
        return (Boolean)this.invoke(IsReady.INSTANCE, new Option[0]);
    }

    @Override
    public Trilean isStorageEnabled(String serviceName) {
        return (Trilean)this.invoke(new IsServiceStorageEnabled(serviceName), new Option[0]);
    }

    @Override
    public ServiceStatus getServiceStatus(String serviceName) {
        return (ServiceStatus)((Object)this.invoke(new GetServiceStatus(serviceName), new Option[0]));
    }

    @Override
    public int getExtendConnectionCount(String sProxyName) {
        return (Integer)this.invoke(new GetExtendConnectionCount(sProxyName), new Option[0]);
    }

    @Override
    public boolean hasExtendConnection(String sProxyName, UUID uuid) {
        return (Boolean)this.invoke(new HasExtendConnection(sProxyName, uuid), new Option[0]);
    }
}

