/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.coherence.options;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.MetaClass;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.Profile;
import com.oracle.bedrock.runtime.java.options.SystemProperties;
import com.oracle.bedrock.runtime.java.options.SystemProperty;
import com.oracle.bedrock.runtime.options.Discriminator;
import java.util.UUID;

public class MemberName
implements Profile,
Option {
    public static final String PROPERTY = "coherence.member";
    private final String name;
    private final boolean useDiscriminator;

    private MemberName(String name, boolean useDiscriminator) {
        this.name = name == null ? UUID.randomUUID().toString() : name;
        this.useDiscriminator = useDiscriminator;
    }

    public String get() {
        return this.name;
    }

    public static MemberName of(String name) {
        return new MemberName(name, false);
    }

    public static MemberName withDiscriminator(String name) {
        return new MemberName(name, true);
    }

    public void onLaunching(Platform platform, MetaClass metaClass, OptionsByType optionsByType) {
        Discriminator discriminator;
        SystemProperties systemProperties = (SystemProperties)optionsByType.get(SystemProperties.class, new Object[0]);
        Object memberName = this.name;
        if (this.useDiscriminator && (discriminator = (Discriminator)optionsByType.get(Discriminator.class, new Object[0])) != null) {
            memberName = (String)memberName + "-" + discriminator.getValue();
        }
        if (systemProperties != null) {
            optionsByType.add((Option)SystemProperty.of((String)PROPERTY, (String)memberName, (Option[])new Option[0]));
        }
    }

    public void onLaunched(Platform platform, Application application, OptionsByType optionsByType) {
    }

    public void onClosing(Platform platform, Application application, OptionsByType optionsByType) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MemberName)) {
            return false;
        }
        MemberName executable = (MemberName)o;
        return this.name.equals(executable.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "MemberName('" + this.name + "')";
    }
}

