/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.coherence.options;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.MetaClass;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.Profile;
import com.oracle.bedrock.runtime.java.options.SystemProperties;
import com.oracle.bedrock.runtime.java.options.SystemProperty;

public class LocalStorage
implements Profile,
Option {
    public static final String PROPERTY = "coherence.distributed.localstorage";
    private boolean enabled;

    private LocalStorage(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public static LocalStorage enabled(boolean enabled) {
        return new LocalStorage(enabled);
    }

    public static LocalStorage enabled() {
        return new LocalStorage(true);
    }

    public static LocalStorage disabled() {
        return new LocalStorage(false);
    }

    public void onLaunching(Platform platform, MetaClass metaClass, OptionsByType optionsByType) {
        SystemProperties systemProperties = (SystemProperties)optionsByType.get(SystemProperties.class, new Object[0]);
        if (systemProperties != null) {
            optionsByType.add((Option)SystemProperty.of((String)PROPERTY, (Object)this.enabled, (Option[])new Option[0]));
        }
    }

    public void onLaunched(Platform platform, Application application, OptionsByType optionsByType) {
    }

    public void onClosing(Platform platform, Application application, OptionsByType optionsByType) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocalStorage)) {
            return false;
        }
        LocalStorage that = (LocalStorage)o;
        return this.enabled == that.enabled;
    }

    public int hashCode() {
        return this.enabled ? 1 : 0;
    }

    public String toString() {
        return "LocalStorage(enabled=" + this.enabled + ")";
    }
}

