/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.coherence.callables;

import com.oracle.bedrock.runtime.concurrent.RemoteCallable;
import com.oracle.coherence.common.base.Logger;
import com.tangosol.net.Coherence;
import com.tangosol.net.Session;

public class GetSession
implements RemoteCallable<Session> {
    private final String m_sCoherenceName;
    private final String m_sSessionName;

    public GetSession() {
        this("", "");
    }

    public GetSession(String sSessionName) {
        this("", sSessionName);
    }

    public GetSession(String sCoherenceName, String sSessionName) {
        this.m_sCoherenceName = sCoherenceName == null || sCoherenceName.isBlank() ? "" : sCoherenceName;
        this.m_sSessionName = sSessionName == null || sSessionName.isBlank() ? "" : sSessionName;
    }

    public Session call() throws Exception {
        Coherence coherence = Coherence.getInstance((String)this.m_sCoherenceName);
        if (coherence == null) {
            Logger.err((String)("In Bedrock GetSession: No Coherence instance exists with name \"" + this.m_sCoherenceName + "\""));
            return null;
        }
        Session session = coherence.getSession(this.m_sSessionName);
        if (session == null) {
            Logger.err((String)("In Bedrock GetSession: No Session instance exists with name \"" + this.m_sSessionName + "\" in Coherence instance \"" + this.m_sCoherenceName + "\""));
            return null;
        }
        return session;
    }
}

