/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.coherence.options;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.LocalPlatform;
import com.oracle.bedrock.runtime.MetaClass;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.Profile;
import com.oracle.bedrock.runtime.java.JavaVirtualMachine;
import com.oracle.bedrock.runtime.java.options.SystemProperties;
import com.oracle.bedrock.runtime.java.options.SystemProperty;
import com.oracle.bedrock.runtime.network.AvailablePortIterator;
import com.oracle.bedrock.util.Capture;
import com.oracle.bedrock.util.PerpetualIterator;
import java.util.Iterator;

public class ClusterPort
implements Profile,
Option {
    public static final String PROPERTY = "coherence.clusterport";
    private Iterator<Integer> ports;

    private ClusterPort(Iterator<Integer> ports) {
        this.ports = ports;
    }

    public Iterator<Integer> getPorts() {
        return this.ports;
    }

    public static ClusterPort from(Iterator<Integer> ports) {
        return new ClusterPort(ports);
    }

    public static ClusterPort of(int port) {
        return new ClusterPort((Iterator<Integer>)new PerpetualIterator((Object)port));
    }

    public static ClusterPort from(AvailablePortIterator ports) {
        return new ClusterPort((Iterator<Integer>)ports);
    }

    public static ClusterPort automatic() {
        return new ClusterPort(null);
    }

    public static ClusterPort of(Capture<Integer> port) {
        return new ClusterPort((Iterator<Integer>)port);
    }

    public void onLaunching(Platform platform, MetaClass metaClass, OptionsByType optionsByType) {
        if (this.ports != null && !this.ports.hasNext()) {
            throw new IllegalStateException("Exhausted the available ports for the ClusterPort");
        }
        SystemProperties systemProperties = (SystemProperties)optionsByType.get(SystemProperties.class, new Object[0]);
        if (systemProperties != null) {
            if (this.ports == null) {
                if (platform instanceof LocalPlatform || platform instanceof JavaVirtualMachine) {
                    this.ports = new Capture((Iterator)LocalPlatform.get().getAvailablePorts());
                } else {
                    throw new IllegalStateException("Can't automatically determine a ClusterPort for the non-LocalPlatform, non-JavaVirtualMachine Platform :" + platform.getName());
                }
            }
            int port = this.ports.next();
            optionsByType.add((Option)SystemProperty.of((String)PROPERTY, (Object)port, (Option[])new Option[0]));
        }
    }

    public void onLaunched(Platform platform, Application application, OptionsByType optionsByType) {
    }

    public void onClosing(Platform platform, Application application, OptionsByType optionsByType) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClusterPort)) {
            return false;
        }
        ClusterPort that = (ClusterPort)o;
        return this.ports.equals(that.ports);
    }

    public int hashCode() {
        return this.ports.hashCode();
    }

    public String toString() {
        return "ClusterPort(" + this.ports + ")";
    }
}

