/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.coherence.callables;

import com.oracle.bedrock.runtime.concurrent.RemoteCallable;
import com.oracle.coherence.common.base.Logger;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.Cluster;
import com.tangosol.net.management.Registry;
import com.tangosol.util.HealthCheck;
import java.util.Optional;

public abstract class AbstractHealthCheckCallable
implements RemoteCallable<Boolean> {
    private final String m_sName;

    protected AbstractHealthCheckCallable(String sName) {
        this.m_sName = sName;
    }

    public Boolean call() throws Exception {
        try {
            Cluster cluster = CacheFactory.getCluster();
            if (cluster != null) {
                Registry management = cluster.getManagement();
                boolean fCheck = this.check(management);
                if (!fCheck) {
                    Logger.info((String)("Bedrock: " + this.getClass().getSimpleName() + " check failed"));
                    return false;
                }
                if (this.m_sName != null && !this.m_sName.isBlank()) {
                    Optional optional = management.getHealthCheck(this.m_sName);
                    if (optional.isPresent()) {
                        fCheck = this.check((HealthCheck)optional.get());
                        if (!fCheck) {
                            Logger.info((String)("Bedrock: " + this.getClass().getSimpleName() + " check failed for HealthCheck " + this.m_sName));
                            return false;
                        }
                    } else {
                        Logger.info((String)("Bedrock: " + this.getClass().getSimpleName() + " check failed, HealthCheck " + this.m_sName + " is not registered"));
                        return false;
                    }
                }
                if (this.m_sName == null || this.m_sName.isBlank()) {
                    Logger.finest((String)("Bedrock: " + this.getClass().getSimpleName() + "  check passed"));
                } else {
                    Logger.finest((String)("Bedrock: " + this.getClass().getSimpleName() + "  check passed for " + this.m_sName));
                }
                return true;
            }
            Logger.info((String)("Bedrock: " + this.getClass().getSimpleName() + " check - cluster is null"));
            return false;
        }
        catch (Exception e) {
            Logger.err((String)("Bedrock: " + this.getClass().getSimpleName() + " check failed"), (Throwable)e);
            return false;
        }
    }

    protected abstract boolean check(Registry var1);

    protected abstract boolean check(HealthCheck var1);
}

