/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.junit;

import com.oracle.bedrock.junit.BootstrapCoherence;
import com.tangosol.net.Coherence;
import com.tangosol.net.CoherenceConfiguration;
import com.tangosol.net.NamedMap;
import com.tangosol.net.Session;
import com.tangosol.net.SessionConfiguration;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class BootstrapCoherenceExtension
implements BeforeAllCallback,
AfterAllCallback {
    public void beforeAll(ExtensionContext context) throws Exception {
        Class clz = context.getTestClass().orElse(null);
        BootstrapCoherence annotation = clz == null ? null : clz.getAnnotation(BootstrapCoherence.class);
        SessionConfiguration sessionConfiguration = this.createSessionConfiguration(annotation);
        CoherenceConfiguration configuration = CoherenceConfiguration.builder().withSession(sessionConfiguration).build();
        int cMillis = annotation == null ? 300000 : annotation.timeout();
        Coherence coherence = (Coherence)Coherence.builder((CoherenceConfiguration)configuration).build().start().get(cMillis, TimeUnit.MILLISECONDS);
        if (clz != null) {
            Session session = coherence.getSession();
            for (Field field : clz.getDeclaredFields()) {
                String sName;
                BootstrapCoherence.Cache fieldCache;
                int nMods = field.getModifiers();
                BootstrapCoherence.Session fieldSession = field.getAnnotation(BootstrapCoherence.Session.class);
                if (fieldSession != null) {
                    if (Modifier.isPublic(nMods) && Modifier.isStatic(nMods)) {
                        field.set(null, session);
                    } else {
                        throw new RuntimeException("Cannot inject Session into field " + field.getName() + " - must be public static");
                    }
                }
                if ((fieldCache = field.getAnnotation(BootstrapCoherence.Cache.class)) == null || (sName = fieldCache.name()).isBlank()) continue;
                if (Modifier.isPublic(nMods) && Modifier.isStatic(nMods)) {
                    field.set(null, session.getCache(sName, new NamedMap.Option[0]));
                    continue;
                }
                throw new RuntimeException("Cannot inject cache \"" + sName + "\" into field \"" + field.getName() + "\" - must be public static");
            }
        }
    }

    public void afterAll(ExtensionContext context) {
        Coherence.closeAll();
    }

    private SessionConfiguration createSessionConfiguration(BootstrapCoherence annotation) {
        SessionConfiguration.Builder builder = SessionConfiguration.builder();
        if (annotation != null) {
            builder.withMode(annotation.mode());
            String sConfig = annotation.config();
            if (!sConfig.isBlank()) {
                builder.withConfigUri(sConfig);
            }
            for (String sProperty : annotation.properties()) {
                int nIndex = sProperty.indexOf(61);
                if (nIndex <= 0) continue;
                String sKey = sProperty.substring(0, nIndex);
                String sValue = sProperty.substring(nIndex + 1);
                builder.withParameter(sKey, (Object)sValue);
            }
        }
        return builder.build();
    }
}

