/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.junit;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class SystemPropertyExtension
implements BeforeAllCallback {
    private final Map<String, Supplier<?>> properties = new HashMap();

    public void beforeAll(ExtensionContext context) throws Exception {
        this.properties.forEach((k, v) -> {
            Object o = v.get();
            if (o != null) {
                System.setProperty(k, String.valueOf(o));
            }
        });
    }

    public SystemPropertyExtension withProperty(String key, Supplier<?> value) {
        this.properties.put(key, value);
        return this;
    }
}

